package com.yeejoin.amos.boot.module.common.api.dto;

import com.alibaba.fastjson.JSONArray;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.Date;

@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class UserPermissionDto {

    /**
     * 主表id-前端页面跳转时页面写死取rowId，所以冗余返回rowId=uid
     */
    private Long rowId;

    /**
     * 主表id
     */
    private Long uid;

    /**
     * 资质表id
     */
    private Long sequenceNbr;

    /**
     * 资质状态
     */
    private String permissionStatus;


    /**
     * 资质状态颜色
     */
    private String permissionStatusColor;

    /**
     * 区域
     */
    private String fullAddress;

    /**
     * 人员类型
     */
    private String postName;

    /**
     * 人员类型
     */
    @JsonIgnore
    private String post;


    /**
     * 姓名
     */
    private String name;

    /**
     * 证件编号
     */
    private String certificateNum;

    /**
     * 所在单位
     */
    private String useUnit;

    /**
     * 个人照片-字符串
     */
    @JsonIgnore
    private String identificationStr;

    /**
     * 个人照片-数组
     */
    private JSONArray identification;

    /**
     * 个人照片路径
     */
    private String photoUrl;

    @JsonIgnore
    private String orgCode;

    @JsonIgnore
    private String cityCode;

    /**
     * 管辖机构名称
     */
    private String superviseOrgName;

    /**
     * 管辖机构code
     */
    private String superviseOrgCode;

    /**
     * 管辖机构CompanyCode
     */
    @JsonIgnore
    private String superviseCompanyCode;

    /**
     * 使用单位统一信用代码
     */
    private String useCode;

    /**
     * 人员类型code
     */
    private String postCode;

    /**
     * 人员子类型code
     */
    private String subPostCode;

    /**
     * 人员子类型名称
     */
    private String subPostName;

    /**
     * 更新时间
     */
    @ApiModelProperty(value = "更新时间")
    protected String recDate;


    /**
     * 创建时间
     */
    @ApiModelProperty(value = "创建时间")
    protected String createDate;

    /**
     * 过滤使用-创建时间-开始
     */
    @ApiModelProperty(value = "创建时间")
    protected Date createDateStart;

    /**
     * 过滤使用-创建时间-结束
     */
    @ApiModelProperty(value = "创建时间")
    protected Date createDateEnd;


}
