package com.yeejoin.amos.boot.module.common.biz.controller;
import java.util.List;

import javax.servlet.http.HttpServletRequest;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.module.common.api.dto.WaterResourcePoolDto;
import com.yeejoin.amos.boot.module.common.biz.service.impl.WaterResourcePoolServiceImpl;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;


/**
* 
*
* @author system_generator
* @date 2021-06-29
*/
@RestController
@Api(tags = "Api")
@RequestMapping(value = "/jcs/water-resource-pool")
public class WaterResourcePoolController extends BaseController {

    @Autowired
    WaterResourcePoolServiceImpl waterResourcePoolServiceImpl;

    /**
             * 新增
    * @return
    */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/save")
	@ApiOperation(httpMethod = "POST", value = "新增", notes = "新增")
	public ResponseModel<WaterResourcePoolDto> save(@RequestBody WaterResourcePoolDto model)
	{
	    model=waterResourcePoolServiceImpl.createWithModel(model);
	    return ResponseHelper.buildResponse(model);
	}
	/**
             * 根据sequenceNbr更新
    * @param sequenceNbr 主键
    * @return
    */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PutMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新", notes = "根据sequenceNbr更新")
	public ResponseModel<WaterResourcePoolDto> updateBySequenceNbrWaterResourcePool(@RequestBody WaterResourcePoolDto model,@PathVariable(value = "sequenceNbr") Long sequenceNbr) {
	    model.setSequenceNbr(sequenceNbr);
	    return ResponseHelper.buildResponse(waterResourcePoolServiceImpl.updateWithModel(model));
	}
	/**
             * 根据sequenceNbr删除
    * @param sequenceNbr 主键
    * @return
    */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除", notes = "根据sequenceNbr删除")
    public ResponseModel<Boolean> deleteBySequenceNbr(HttpServletRequest request, @PathVariable(value = "sequenceNbr") Long sequenceNbr){
        return ResponseHelper.buildResponse(waterResourcePoolServiceImpl.removeById(sequenceNbr));
    }
    /**
             * 根据sequenceNbr查询
    * @param sequenceNbr  主键
    * @return
    */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "GET",value = "根据sequenceNbr查询单个",  notes = "根据sequenceNbr查询单个")
	public ResponseModel<WaterResourcePoolDto> seleteOne(@PathVariable Long sequenceNbr)
	{
	    return ResponseHelper.buildResponse(waterResourcePoolServiceImpl.queryBySeq(sequenceNbr));
	}
	/**
             * 列表分页查询
    *@param current 当前页
    *@param current 每页大小
    * @return
    */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/page")
	@ApiOperation(httpMethod = "GET",value = "分页查询",  notes = "分页查询")
	public ResponseModel<Page<WaterResourcePoolDto>> queryForPage(@RequestParam(value = "current") int current,@RequestParam(value = "size") int size)
	{
	    Page<WaterResourcePoolDto> page=new Page<WaterResourcePoolDto>();
	    page.setCurrent(current);
	    page.setSize(size);
	    return ResponseHelper.buildResponse(waterResourcePoolServiceImpl.queryForWaterResourcePoolPage(page));
	}
	/**
	*列表全部数据查询
	*@return
	*/
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET",value = "列表全部数据查询",   notes = "列表全部数据查询")
	@GetMapping(value = "/list")
	public ResponseModel<List<WaterResourcePoolDto>>  selectForList()
	{
	    return ResponseHelper.buildResponse(waterResourcePoolServiceImpl.queryForWaterResourcePoolList());
	}
}
