package com.yeejoin.amos.boot.module.cylinder.api.mapper;

import java.util.List;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.cylinder.api.dto.EquEnterDto;
import com.yeejoin.amos.boot.module.cylinder.api.dto.TzBaseEnterpriseInfoDto;
import com.yeejoin.amos.boot.module.cylinder.api.entity.TzBaseEnterpriseInfo;
import org.apache.ibatis.annotations.Param;

/**
 * 企业数据信息 Mapper 接口
 *
 * @author duanwei
 * @date 2022-08-10
 */
public interface TzBaseEnterpriseInfoMapper extends BaseMapper<TzBaseEnterpriseInfo> {

	/**
	 * 查找企业关联设备详情列表
	 * 
	 * @param sequenceNbr 企业id
	 * @return EquEnterDto 使用登记证代码、设备名称、设备类别、设备位置
	 */
	List<EquEnterDto> getInfo(String sequenceNbr);

	/**
	 * 根据企业名称查找设备
	 *
	 * @param useUnit 企业名称
	 * @return
	 */
	List<EquEnterDto> getInfoByUseUnit(String useUnit);

	/**
	 * 根据企业名称查找企业详情信息
	 * @param useUnit
	 * @return
	 */
	TzBaseEnterpriseInfo selectByUseUnit(String useUnit);


	IPage<TzBaseEnterpriseInfoDto> page(Page<TzBaseEnterpriseInfoDto> page, TzBaseEnterpriseInfoDto tzBaseEnterpriseInfoDto);

	IPage<TzBaseEnterpriseInfoDto> pageList(Page<TzBaseEnterpriseInfoDto> page, TzBaseEnterpriseInfoDto tzBaseEnterpriseInfoDto, List orgCodeList);

	List<TzBaseEnterpriseInfoDto> queryByUseCode(@Param("useCodes") List<String> useCode);

	List<TzBaseEnterpriseInfoDto> queryByAppId(@Param("appIds") List<String> appIds);
}
