package com.yeejoin.amos.boot.module.jg.biz.edit.process.biz.transferNotice;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import com.yeejoin.amos.boot.module.jg.api.entity.JgTransferNotice;
import com.yeejoin.amos.boot.module.jg.api.entity.JgTransferNoticeEq;
import com.yeejoin.amos.boot.module.jg.biz.service.impl.JgTransferNoticeEqServiceImpl;
import com.yeejoin.amos.boot.module.jg.biz.service.impl.JgTransferNoticeServiceImpl;
import lombok.Getter;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

@Service
@RequiredArgsConstructor
@Getter
public class TransferNoticeEditUpdateService {

    private final JgTransferNoticeServiceImpl transferNoticeService;

    private final JgTransferNoticeEqServiceImpl maintainNoticeEqService;

    public Set<String> getEqsByApplyNo(String applyNo) {
        JgTransferNotice jgInstallationNotice = transferNoticeService.getOne(new LambdaQueryWrapper<JgTransferNotice>().eq(JgTransferNotice::getApplyNo, applyNo).select(BaseEntity::getSequenceNbr));
        List<JgTransferNoticeEq> eqs = maintainNoticeEqService.list(new LambdaQueryWrapper<JgTransferNoticeEq>().eq(JgTransferNoticeEq::getEquipTransferId, jgInstallationNotice.getSequenceNbr()).select(JgTransferNoticeEq::getEquId, BaseEntity::getSequenceNbr));
        return eqs.stream().map(JgTransferNoticeEq::getEquId).collect(Collectors.toSet());
    }

    public JgTransferNotice getOneByApplyNo(String applyNo) {
        return transferNoticeService.getOne(new LambdaQueryWrapper<JgTransferNotice>().eq(JgTransferNotice::getApplyNo, applyNo));
    }

}