package com.yeejoin.amos.boot.module.jg.biz.handler.toBeSubmit;

import com.yeejoin.amos.boot.biz.common.bo.ReginParams;
import com.yeejoin.amos.boot.module.jg.api.enums.BusinessTypeEnum;
import com.yeejoin.amos.boot.module.jg.biz.handler.strategy.ToBeSubmitDetailStrategy;
import com.yeejoin.amos.boot.module.jg.biz.service.impl.JgChangeRegistrationReformServiceImpl;
import com.yeejoin.amos.boot.module.ymt.api.enums.ApplicationFormTypeEnum;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import java.util.HashMap;
import java.util.Map;

@Component
public class RegistrationReformStrategyHandler implements ToBeSubmitDetailStrategy {

    @Autowired
    private JgChangeRegistrationReformServiceImpl registrationReformService;

    @Override
    public Map<String, Map<String, Object>> getDetails(Long sequenceNbr, ReginParams reginParams) {
        Map<String, Object> notice = registrationReformService.getDetail(String.valueOf(sequenceNbr), "", reginParams.getCompany());
        Map<String, Object> basic = new HashMap<>();
        Map<String, Object> useRegFormUpload = new HashMap<>();
        basic.put("type", ApplicationFormTypeEnum.GZBG.getBusinessCode());
        basic.put("receiveOrgCreditCode1", notice.get("receiveCompanyCode"));
        basic.put("businessScenarios", "0");
        basic.put("code", notice.get("EQU_LIST_CODE"));
        notice.put("EQU_CATEGORY_CODE", notice.get("equCategory"));
        basic.put("equCategory", notice.get("equCategory"));
        basic.put("isTempEquip", true);
        Map<String, Map<String, Object>> result = new HashMap<>();
        result.put("notice", notice);
        result.put("basic", basic);
        useRegFormUpload.put("uploadMode", notice.get("uploadMode"));
        useRegFormUpload.put("useRegistrationFormUrl", notice.get("useRegistrationFormUrl"));
        useRegFormUpload.put("applicationFormFileUrl", notice.get("applicationFormFileUrl"));
        useRegFormUpload.put("applyNo", notice.get("applyNo"));
        result.put("useRegFormUpload", useRegFormUpload);
        return result;
    }

    @Override
    public String supportBusinessType() {
        return BusinessTypeEnum.JG_RENOVATION_REGISTRATION.getName();
    }
}
