package com.yeejoin.amos.boot.module.jyjc.biz.controller;

import com.alibaba.fastjson.JSONObject;
import com.yeejoin.amos.boot.module.jyjc.api.model.InspectionPlanModel;
import com.yeejoin.amos.boot.module.jyjc.biz.service.impl.InspectionPlanServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

/**
 * 检验检测计划控制期
 *
 * @author Administrator
 */
@RestController
@RequestMapping(value = "/inspection/plan")
@Api(tags = "计划排期")
@RequiredArgsConstructor
public class InspectionPlanController {

    private final InspectionPlanServiceImpl inspectionPlanService;

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/{applicationSeq}/save")
    @ApiOperation(httpMethod = "GET", value = "计划排期保存", notes = "计划排期保存")
    public ResponseModel<InspectionPlanModel> savePlanData(@PathVariable String applicationSeq,
                                                           @RequestBody InspectionPlanModel model) {
        return ResponseHelper.buildResponse(inspectionPlanService.savePlanData(applicationSeq, model));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/{applicationSeq}/detail")
    @ApiOperation(httpMethod = "GET", value = "计划排期详情", notes = "计划排期详情")
    public ResponseModel<JSONObject> savePlanData(@PathVariable String applicationSeq) {
        return ResponseHelper.buildResponse(inspectionPlanService.getDetail(applicationSeq));
    }


}
