package com.yeejoin.amos.patrol.feign;

import com.yeejoin.amos.patrol.business.param.PushMsgParam;
import com.yeejoin.amos.patrol.business.service.impl.RulePlanService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

@Service("pushFeignServer")
public class PushFeignServer {

    @Autowired
    RulePlanService rulePlanService;

    /**
     * 批量发送
     *
     * @param pushMsgParam 消息参数
     */
    public void sendMessage(List<PushMsgParam> pushMsgParam) {
        pushMsgParam.forEach(rulePlanService::sendRule);
    }

    /**
     * 单个发送
     *
     * @param pushMsgParam 消息参数
     */
    public void sendMessage(PushMsgParam pushMsgParam) {
        rulePlanService.sendRule(pushMsgParam);
    }

}
