package com.yeejoin.equipmanage.common.entity;

import cn.afterturn.easypoi.excel.annotation.Excel;
import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.yeejoin.equipmanage.common.entity.publics.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.Date;
import java.util.List;

/**
 * @author wujiang
 * @date 2020-07-07
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("wl_equipment")
@ApiModel(value = "Equipment对象", description = "")
public class Equipment extends BaseEntity {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "装备名称")
    @TableField("name")
    @Excel(name = "装备名称", width = 20, orderNum = "1")
    private String name;

    @ApiModelProperty(value = "装备编码")
    @TableField("code")
    @Excel(name = "装备编码", width = 20, orderNum = "2")
    private String code;

    @ApiModelProperty(value = "装备分类id")
    @TableField("category_id")
    @Excel(name = "装备分类id", width = 20, orderNum = "3")
    private Long categoryId;

    @ApiModelProperty(value = "装备型号")
    @Excel(name = "装备型号", width = 20, orderNum = "4")
    @TableField("country")
    private String country;

    @ApiModelProperty(value = "存放位置")
    @Excel(name = "存放位置", width = 20, orderNum = "5")
    @TableField("area")
    private String area;

    @ApiModelProperty(value = "生产厂家")
    @Excel(name = "生产厂家", width = 20, orderNum = "6")
    @TableField("made_in")
    private String madeIn;


    @JsonFormat(pattern = "yyyy-MM-dd")
    @TableField("open_time")
    @ApiModelProperty(value = "出厂时间")
    @Excel(name = "出厂时间", width = 20, orderNum = "7")
    private Date openTime;


    @ApiModelProperty(value = "工作时间")
    @Excel(name = "工作时间", width = 20, orderNum = "8")
    @TableField("remark")
    private String remark;

    @ApiModelProperty(value = "所属单位")
    @TableField("company_name")
    @Excel(name = "所属单位", width = 20, orderNum = "9")
    private String companyName;

    @JsonFormat(pattern = "yyyy-MM-dd")
    @TableField("join_time")
    @ApiModelProperty(value = "入库时间")
    @Excel(name = "入库时间", width = 20, orderNum = "10")
    private Date joinTime;




    @ApiModelProperty(value = "保养周期")
    private Short maintenanceCycle;

    @ApiModelProperty(value = "检查周期（天）")
    private Short checkCycle;



    @ApiModelProperty(value = "管理方式 单件还是批量管理模式，单件S，批量：P")
    private Long managementStyle;

    @ApiModelProperty(value = "修改人")
    private Long reviserId;
    @ApiModelProperty(value = "修改时间")
    private Date dateUpdated;

    @ApiModelProperty(value = "创建人")
    private Long createrId;

    private Long unitId;

    @TableField(exist = false)
    private Unit unit;



    @ApiModelProperty(value = "生产厂家")
    private String manufacturer;

    private String img;

    private String video;

    @ApiModelProperty(value = "标识规范")
    private String markSpecification;

    @ApiModelProperty(value = "供应商ID")
    private Long supplierId;

    @TableField(insertStrategy = FieldStrategy.IGNORED,updateStrategy = FieldStrategy.IGNORED)
    private String prefQuota;

    @TableField(exist = false)
    private EquipmentCategory equipmentCategory;

    @TableField(exist = false)
    private List<EquProperty> equPropertyList;

    @ApiModelProperty(value = "巡查规范")
    private String inspectionSpec;

    @ApiModelProperty(value = "维保规范")
    private String maintenanceSpec;

    @TableField(exist = false)
    private boolean isUse;

    /**
     * 是否物联 【0：否；1：是】
     */
    @TableField(value = "is_iot")
    private String isIot = "0";

    /**
     * 警情消除策略 【0：收到复位信号自动消除；1：警情处理确认后消除】
     */
    @TableField(value = "clean_type")
    private String cleanType = "0";
}
