package com.yeejoin.amos.boot.module.tzs.flc.biz.controller;

import org.springframework.web.bind.annotation.RequestMapping;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.Api;
import org.springframework.web.bind.annotation.RestController;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import java.util.List;
import com.yeejoin.amos.boot.module.tzs.flc.biz.service.impl.CylinderInfoServiceImpl;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;
import org.springframework.beans.factory.annotation.Autowired;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.tzs.flc.api.dto.CylinderInfoDto;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.foundation.enumeration.UserType;

/**
 * 气瓶基本信息
 *
 * @author system_generator
 * @date 2021-12-14
 */
@RestController
@Api(tags = "气瓶基本信息Api")
@RequestMapping(value = "/cylinder-info")
public class CylinderInfoController extends BaseController {

    @Autowired
    CylinderInfoServiceImpl cylinderInfoServiceImpl;

    /**
     * 新增气瓶基本信息
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/save")
	@ApiOperation(httpMethod = "POST", value = "新增气瓶基本信息", notes = "新增气瓶基本信息")
	public ResponseModel<CylinderInfoDto> save(@RequestBody CylinderInfoDto model) {
	    model = cylinderInfoServiceImpl.createWithModel(model);
	    return ResponseHelper.buildResponse(model);
	}

	/**
     * 根据sequenceNbr更新
     *
     * @param sequenceNbr 主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PutMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新气瓶基本信息", notes = "根据sequenceNbr更新气瓶基本信息")
	public ResponseModel<CylinderInfoDto> updateBySequenceNbrCylinderInfo(@RequestBody CylinderInfoDto model,@PathVariable(value = "sequenceNbr") Long sequenceNbr) {
	    model.setSequenceNbr(sequenceNbr);
	    return ResponseHelper.buildResponse(cylinderInfoServiceImpl.updateWithModel(model));
	}

	/**
     * 根据sequenceNbr删除
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除气瓶基本信息", notes = "根据sequenceNbr删除气瓶基本信息")
    public ResponseModel<Boolean> deleteBySequenceNbr(HttpServletRequest request, @PathVariable(value = "sequenceNbr") Long sequenceNbr){
        return ResponseHelper.buildResponse(cylinderInfoServiceImpl.removeById(sequenceNbr));
    }

    /**
     * 根据sequenceNbr查询
     *
	 * @param sequenceNbr  主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "GET",value = "根据sequenceNbr查询单个气瓶基本信息",  notes = "根据sequenceNbr查询单个气瓶基本信息")
	public ResponseModel<CylinderInfoDto> selectOne(@PathVariable Long sequenceNbr) {
	    return ResponseHelper.buildResponse(cylinderInfoServiceImpl.queryBySeq(sequenceNbr));
	}

	/**
     * 列表分页查询
     *
     * @param current 当前页
     * @param current 每页大小
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/page")
	@ApiOperation(httpMethod = "GET",value = "气瓶基本信息分页查询",  notes = "气瓶基本信息分页查询")
	public ResponseModel<Page<CylinderInfoDto>> queryForPage(@RequestParam(value = "current") int current,@RequestParam
                    (value = "size") int size) {
	    Page<CylinderInfoDto> page = new Page<CylinderInfoDto>();
	    page.setCurrent(current);
	    page.setSize(size);
	    return ResponseHelper.buildResponse(cylinderInfoServiceImpl.queryForCylinderInfoPage(page));
	}

	/**
	 * 列表全部数据查询
     *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET",value = "气瓶基本信息列表全部数据查询",   notes = "气瓶基本信息列表全部数据查询")
	@GetMapping(value = "/list")
	public ResponseModel<List<CylinderInfoDto>> selectForList() {
	    return ResponseHelper.buildResponse(cylinderInfoServiceImpl.queryForCylinderInfoList());
	}
}
