package com.yeejoin.amos.boot.module.cylinder.flc.api.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import org.typroject.tyboot.core.rdbms.orm.entity.BaseEntity;

import java.time.LocalDate;
import java.util.Date;

/**
 * 气站卸液量记录表
 * @author kinky
 *
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("tz_cylinder_offloading")
public class CylinderOffloading extends BaseEntity {

	private static final long serialVersionUID = 1L;

	@TableField("offloading_volume")
	private String offloadingVolume;	//卸液量（单位吨）

	@TableField("credit_code")
	private String creditCode;	//对接单位统一信用代码

	@ApiModelProperty(value = "对接接口版本")
	protected String version = "v1";

	@ApiModelProperty(value = "对接公司编码")
	@TableField("app_id")
	private String appId;

	@ApiModelProperty(value = "同步时间  yyyy-MM-dd HH24:mi:ss")
	private Date syncDate;

	@ApiModelProperty(value = "统计同步时间 yyyy-MM-dd")
	private LocalDate statisticsSyncDate;

	@ApiModelProperty(value = "0-新增")
	private Integer syncState;
}
