package com.yeejoin.amos.boot.module.common.api.enums;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;

public enum NoticBusinessTypeEnum {
    AZ("az","安装"),
    WX("wx","维修"),
    GZ("gz","改造"),
    YZ("yz","移装");


    private NoticBusinessTypeEnum(String code, String name){
        this.code=code;
        this.name=name;
    }

    private String code;

    private String name;

    public String getCode() {
        return code;
    }

    public String getName() {
        return name;
    }

    public static List<HashMap<String,Object>> getEnumList() {
        List<HashMap<String, Object>> list = new ArrayList<>();
        for (NoticBusinessTypeEnum testEnum : EnumSet.allOf(NoticBusinessTypeEnum.class)) {
            HashMap<String, Object> map = new HashMap<>();
            map.put("title",testEnum.name);
            map.put("value",testEnum.code);
            list.add(map);
        }
        return list;
    }

}
