package com.yeejoin.amos.boot.module.app.api.dto;

import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;

/**
 * 安全追溯-锅炉
 *
 * @author cpp
 * @date 2023-04-06 15:21:22
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value="paramBoiler", description="锅炉技术参数")
public class EquipTechParamBoilerModel extends BaseDto {
    private static final long serialVersionUID = 1L;

            @ApiModelProperty(value = "")
        private String instanceId;
            @ApiModelProperty(value = "")
        private String status;
            @ApiModelProperty(value = "设备等级")
        private String deviceLevel;
            @ApiModelProperty(value = "额定蒸发量（热功率）")
        private BigDecimal ratedEvaporationCapacityThermalPower;
            @ApiModelProperty(value = "额定工作压力")
        private BigDecimal ratedWorkingPressure;
            @ApiModelProperty(value = "额定工作温度")
        private BigDecimal ratedOperatingTemperature;
            @ApiModelProperty(value = "设计热效率")
        private BigDecimal designThermalEfficiency;
            @ApiModelProperty(value = "给水温度")
        private BigDecimal feedwaterTemperature;
            @ApiModelProperty(value = "额定出/回水(油)温度")
        private BigDecimal ratedOutletReturnWaterOilTemperature;
            @ApiModelProperty(value = "锅炉本体水（油）容积")
        private BigDecimal waterOilVolumeOfBoilerProper;
            @ApiModelProperty(value = "整装锅炉本体液压试验介质/压力")
        private BigDecimal hydraulicTestMediumPressureOfPackagedBoilerBody;
            @ApiModelProperty(value = "再热器进（出）口温度")
        private BigDecimal inletOutletTemperatureOfReheater;
            @ApiModelProperty(value = "再热器进（出）口压力")
        private BigDecimal reheaterInletOutletPressure;
            @ApiModelProperty(value = "再热蒸汽流量")
        private BigDecimal reheatSteamFlow;
            @ApiModelProperty(value = "燃料（热源）种类")
        private String fuelType;
            @ApiModelProperty(value = "受压部件名称")
        private String nameOfPressureParts;
            @ApiModelProperty(value = "受压部件材料")
        private String materialOfPressureParts;
            @ApiModelProperty(value = "受压部件壁厚")
        private BigDecimal wallThicknessOfPressureParts;
            @ApiModelProperty(value = "受压部件无损检测方法")
        private String nonDestructiveTestingMethodsForPressureParts;
            @ApiModelProperty(value = "受压部件无损检测比例")
        private BigDecimal proportionOfNdtForPressureParts;
            @ApiModelProperty(value = "受压部件热处理温度")
        private BigDecimal heatTreatmentTemperatureOfPressureParts;
            @ApiModelProperty(value = "受压部件热处理时间")
        private BigDecimal heatTreatmentTimeOfPressureParts;
            @ApiModelProperty(value = "受压部件水（耐）压试验介质")
        private String hydrostaticTestMedium;
            @ApiModelProperty(value = "受压部件水（耐）压试验压力")
        private BigDecimal hydrostaticTestPressure;
            @ApiModelProperty(value = "燃烧方式")
        private String combustionMode;
            @ApiModelProperty(value = "有机热载体锅炉气密试验介质/压力")
        private BigDecimal glAirtightTest;

            @ApiModelProperty(value = "安装附件与有关装置")
        private String safetyAccessoriesAndRelatedDevices;

    
}
