package com.yeejoin.amos.boot.module.elevator.api.entity;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.ColumnWidth;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import java.util.Date;

/**
 * 
 *
 * @author system_generator
 * @date 2023-11-02
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("tzs_alert_statistics")
public class AlertStatistics extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 监管单位ID
     */
	@TableField("supervisory_unit_id")
    private String supervisoryUnitId;

    /**
     * 监管单位名称
     */
	@TableField("supervisory_unit_name")
    @ColumnWidth(30)
    @ExcelProperty(value = "区  域", index = 0)
    private String supervisoryUnitName;

    /**
     * 监管单位orgcode
     */
	@TableField("supervisory_unit_org_code")
    private String supervisoryUnitOrgCode;

    /**
     * 电梯总数
     */
	@TableField("elevator_num")
    @ExcelProperty(value = "电梯总数（台）", index = 1)
    private Integer elevatorNum;

    /**
     * 应急事件
     */
	@TableField("emergency_events")
    private Integer emergencyEvents;

    /**
     * 困人救援
     */
	@TableField("trapped_people")
    private Integer trappedPeople;

    /**
     * 故障救援
     */
	@TableField("breakdown_rescue")
    private Integer breakdownRescue;

    /**
     * 解救人员
     */
	@TableField("rescue_personnel")
    @ExcelProperty(value = "解救被困人员（起)", index = 5)
    private Integer rescuePersonnel;

    /**
     * 投诉建议
     */
	@TableField("complaint")
    @ExcelProperty(value = "投诉建议（条)", index = 6)
    private Integer complaint;

    /**
     * 故障率
     */
	@TableField("failure_rate")
    @ExcelProperty(value = "电梯故障率", index = 7)
    private String failureRate;

    /**
     * 统计日期
     */
	@TableField("statistics_date")
    private String statisticsDate;

    /**
     * 统计开始时间
     */
	@TableField("start_date")
    private String startDate;

    /**
     * 统计结束时间
     */
	@TableField("end_date")
    private String endDate;

    @ExcelProperty(value = "电梯应急总事件（起）", index = 2)
    @TableField(exist = false)
    private String avgDaysEmergencyEvents;

    @ExcelProperty(value = "困  人（起）", index = 3)
    @TableField(exist = false)
    private String avgDaysTrappedPeople;

    @ExcelProperty(value = "故  障（起)", index = 4)
    @TableField(exist = false)
    private String avgDaysBreakdownRescue;
}
