package com.yeejoin.amos.boot.module.jg.api.vo;

import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.annotation.TableField;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;
import java.util.List;
import java.util.Map;

@Data
public class JgMaintenanceContractVo {

    @TableField("维保备案编号")
    private String applyNo;

    @TableField("办理状态")
    private String applyStatus;

    @TableField("流程实例id")
    private String instanceId;

    @TableField("维保备案日期")
    private Date applyDate;

    @TableField("设备类型")
    private String equType;

    @TableField("使用单位统一信用代码")
    private String useUnitCode;

    @TableField("使用单位")
    private String useUnitName;

    @TableField("接收机构统一信用代码")
    private String receiveOrgCode;

    @TableField("接收机构")
    private String receiveOrgName;

    @TableField("维保单位统一信用代码")
    private String maintenanceUnitCode;

    @TableField("维保单位名称")
    private String maintenanceUnitName;

    @TableField("维保合同开始日期")
    private Date informStart;

    @TableField("维保合同结束日期")
    private Date informEnd;

    @TableField("维保负责人一id")
    private String maintenanceManagerOneId;

    @TableField("维保负责人一姓名")
    private String maintenanceManagerOneName;

    @TableField("维保负责人一手机号")
    private String maintenanceManagerOnePhone;

    @TableField("维保负责人一身份证号码")
    private String maintenanceManagerOneIdNum;

    @TableField("维保负责人二id")
    private String maintenanceManagerTwoId;

    @TableField("维保负责人二姓名")
    private String maintenanceManagerTwoName;

    @TableField("维保负责人二手机号")
    private String maintenanceManagerTwoPhone;

    @TableField("维保负责人二身份证号码")
    private String maintenanceManagerTwoIdNum;

    @TableField("紧急救援电话")
    private String emergencyCall;

    @TableField("24小时维保电话")
    private String maintenance24Tel;

    @TableField("备注")
    private String remark;

    @TableField("录入单位ID")
    private String inputUnitNo;

    @TableField("维保合同照片")
    private List maintenanceContract;

    @TableField("维保周期")
    private Integer maintenanceCycle;

    @TableField("大修周期")
    private Integer overhaulCycle;

    @TableField("设备数量")
    private Integer equNum;


    @TableField("创建人ID")
    private String createUserId;

    @TableField("创建时间")
    private Date createDate;

    @TableField("管理员id")
    private String maintenanceManagerId;

    @ApiModelProperty(value = "管理员姓名")
    private String maintenanceManagerName;

    @ApiModelProperty(value = "主键ID")
    protected Long sequenceNbr;

    @ApiModelProperty(value = "更新时间")
    protected Date recDate;

    @ApiModelProperty(value = "更新人id")
    protected String recUserId;

    @ApiModelProperty(value = "更新人")
    protected String recUserName;

    @ApiModelProperty(value = "是否删除")
    private Boolean isDelete = false;

    @ApiModelProperty("instance_status")
    private String instanceStatus;

    @ApiModelProperty("next_execute_ids")
    private String nextExecuteIds;

    @ApiModelProperty("promoter")
    private String promoter;

    @ApiModelProperty("status")
    private String status;

    @ApiModelProperty("设备种类")
    private String equList;

    @ApiModelProperty("设备类别")
    private String equCategory;

    private List<? extends Map<?,?>> equipmentLists;

    @ApiModelProperty("工作流下一节点任务id")
    private String nextTaskId;

    @ApiModelProperty("安全管理员姓名联系方式")
    private String maintenanceManagerPhone;

    @ApiModelProperty (value = "其他附件")
    private JSONArray otherAccessories;

    @ApiModelProperty(value = "当前登陆人单位类型")
    private String unitType;
}
