package com.yeejoin.amos.boot.module.jg.api.mapper;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.jg.api.dto.JgReformNoticeDto;
import com.yeejoin.amos.boot.module.jg.api.entity.JgReformNotice;
import org.apache.ibatis.annotations.MapKey;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * 改造告知 Mapper 接口
 *
 * @author system_generator
 * @date 2023-12-19
 */
public interface JgReformNoticeMapper extends CustomBaseMapper<JgReformNotice> {
    /**
     * 分页查询
     *
     * @param page  分页对象
     * @param model 查询参数
     * @param type  类型：enterprise-企业端、supervision-监管端
     * @return 改造告知列表
     */
    Page<JgReformNotice> queryForPage(Page<JgReformNotice> page, @Param ("param") JgReformNoticeDto model,
                                      @Param("type") String type, @Param("orgCode") String orgCode,
                                      @Param("currentUserId") String currentUserId);

    /**
     * 根据改造告知编号查询设备、设计、制造等信息
     *
     * @param sequenceNbr 改造告知编号
     */
    @MapKey ("sequenceNbr")
    List<Map<String, Object>> queryEquipInformation(@Param("sequenceNbr") long sequenceNbr);

    void updatePromoter(@Param("id") Long id);
}
