package com.yeejoin.amos.boot.module.jg.biz.controller;

import com.alibaba.fastjson.JSONObject;
import com.yeejoin.amos.boot.biz.common.bo.ReginParams;
import com.yeejoin.amos.boot.module.jg.api.dto.JgChangeRegistrationReformDto;
import org.springframework.web.bind.annotation.RequestMapping;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.Api;
import org.springframework.web.bind.annotation.RestController;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.yeejoin.amos.boot.module.jg.biz.service.impl.JgChangeRegistrationReformServiceImpl;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.foundation.enumeration.UserType;

import javax.servlet.http.HttpServletResponse;

/**
 * 改造变更登记
 *
 * @author system_generator
 * {@code @Date} 2023-12-20
 */
@RestController
@Api(tags = "改造变更登记Api")
@RequestMapping(value = "/jg-change-registration-reform")
public class JgChangeRegistrationReformController extends BaseController {

    @Autowired
    JgChangeRegistrationReformServiceImpl jgChangeRegistrationReformServiceImpl;

    /**
     * 新增改造变更登记
     *
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/save")
	@ApiOperation(httpMethod = "POST", value = "新增改造变更登记", notes = "新增改造变更登记")
	public ResponseModel<Object> save(@RequestBody JSONObject map) {
	    return ResponseHelper.buildResponse(jgChangeRegistrationReformServiceImpl.save(map));
	}
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/flowExecute")
	@ApiOperation(httpMethod = "POST", value = "执行流程", notes = "执行流程")
	public ResponseModel<Object> flowExecute(@RequestBody JSONObject map) {
		jgChangeRegistrationReformServiceImpl.flowExecute(Long.valueOf(String.valueOf(map.get("sequenceNbr"))),String.valueOf(map.get("instanceId")), String.valueOf(map.get("operate")), String.valueOf(map.get("comment")));
		return ResponseHelper.buildResponse("ok");
	}
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/withdraw")
	@ApiOperation(httpMethod = "POST", value = "撤回", notes = "撤回")
	public ResponseModel<Object> withdraw(@RequestBody JSONObject map) {
		jgChangeRegistrationReformServiceImpl.withdraw(String.valueOf(map.get("instanceId")));
		return ResponseHelper.buildResponse("ok");
	}


	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/deleteBatch")
	@ApiOperation(httpMethod = "POST", value = "批量删除", notes = "批量删除")
	public ResponseModel<Object> deleteBatch(@RequestBody JSONObject map) {
		List<Long> ids = (List<Long>) map.get("ids");
		jgChangeRegistrationReformServiceImpl.deleteBatch(ids);
		return ResponseHelper.buildResponse("ok");
	}

	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/delete")
	@ApiOperation(httpMethod = "POST", value = "删除", notes = "删除")
	public ResponseModel<Object> deleteMessage(@RequestParam("id") Long id) {
		ArrayList<Long> ids = new ArrayList<>();
		ids.add(id);
		jgChangeRegistrationReformServiceImpl.deleteBatch(ids);
		return ResponseHelper.buildResponse("ok");
	}

	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET", value = "列表全部数据查询", notes = "列表全部数据查询")
	@GetMapping(value = "/getList")
	public ResponseModel<Page<Map<String, Object>>> getList(JgChangeRegistrationReformDto dto,
															@RequestParam(value = "current") int current,
															@RequestParam(value = "size") int size) {
		Page<Map<String, Object>> page = new Page<>(current, size);
		ReginParams reginParams = getSelectedOrgInfo();
		if(reginParams.getCompany().getLevel().equals(COMPANY_TYPE_COMPANY)){
			dto.setDataType(COMPANY_TYPE_COMPANY);
			dto.setUseUnitCreditCode(reginParams.getCompany().getCompanyCode());
		} else {
			dto.setDataType(COMPANY_TYPE_SUPERVISION);
			dto.setReceiveOrgCode(reginParams.getCompany().getCompanyCode());
		}
		return ResponseHelper.buildResponse(jgChangeRegistrationReformServiceImpl.getList(dto, page,  dto.getRoleIds()));
	}


	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET", value = "获取详情", notes = "获取详情")
	@GetMapping(value = "/getDetail")
	public ResponseModel<Map<String, Object>> getDetail(@RequestParam("currentDocumentId") String currentDocumentId,@RequestParam(value = "equipId",required = false) String equipId) {
		return ResponseHelper.buildResponse(jgChangeRegistrationReformServiceImpl.getDetail(currentDocumentId,equipId));
	}

	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET", value = "获取使用单位code及name", notes = "获取使用单位code及name")
	@GetMapping(value = "/getMessage")
	public ResponseModel<Map<String, Object>> getMessage() {
		ReginParams selectedOrgInfo = getSelectedOrgInfo();
		HashMap<String, Object> map = new HashMap<>();
		map.put("useUnitCreditCode", selectedOrgInfo.getCompany().getCompanyCode());
		map.put("useUnitName", selectedOrgInfo.getCompany().getCompanyName());
		return ResponseHelper.buildResponse(map);
	}

	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/export")
	@ApiOperation(httpMethod = "GET", value = "改造登记-导出使用登记证", notes = "改造登记-导出使用登记证")
	public void exportImageZip(HttpServletResponse response, @RequestParam("sequenceNbr") String sequenceNbr){
		jgChangeRegistrationReformServiceImpl.exportUseRegistrationCertificate(sequenceNbr, response);
	}
}
