package com.yeejoin.amos.boot.module.jg.api.mapper;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.jg.api.dto.JgInstallationNoticeDto;
import com.yeejoin.amos.boot.module.jg.api.entity.JgInstallationNotice;
import org.apache.ibatis.annotations.MapKey;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * Mapper 接口
 *
 * @author system_generator
 * @date 2023-12-12
 */
public interface JgInstallationNoticeMapper extends CustomBaseMapper<JgInstallationNotice> {
    /**
     * 分页查询
     *
     * @param page  分页对象
     * @param model 查询参数
     * @param type  类型：enterprise-企业端、supervision-监管端
     * @return 安装告知列表
     */
    Page<Map<String, Object>> queryForPage(Page<JgInstallationNotice> page, @Param("param") JgInstallationNoticeDto model, @Param("type") String type, @Param("orgCode") String orgCode);

    /**
     * 根据安装告知编号查询设备、设计、制造等信息
     *
     * @param sequenceNbr 安装告知编号
     */
    @MapKey("sequenceNbr")
    List<Map<String, Object>> queryEquipInformation(@Param("sequenceNbr") long sequenceNbr);
}
