package com.yeejoin.amos.boot.module.jyjc.api.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

/**
 * @author LiuLin
 * @date 2024年01月03日 18:05
 */
@Getter
@AllArgsConstructor
public enum CategoryEnum {
    DETECTION("detection", JYJCTypeEnum.AQFJY, JYJCTypeEnum.DTJC),
    FIRST_INSPECTION("firstinspect", JYJCTypeEnum.DQJY, JYJCTypeEnum.SCJY),
    SUPERVISE("supervise", JYJCTypeEnum.WXJDJY, JYJCTypeEnum.GZJDJY, JYJCTypeEnum.AZJDJY);

    private final String category;
    private final Set<JYJCTypeEnum> associatedTypes;

    CategoryEnum(String category, JYJCTypeEnum... types) {
        this.category = category;
        this.associatedTypes = new HashSet<>(Arrays.asList(types));
    }

    public static String getCategoryByType(JYJCTypeEnum type) {
        for (CategoryEnum ce : values()) {
            if (ce.associatedTypes.contains(type)) {
                return ce.category;
            }
        }
        return null;
    }
}
