package com.yeejoin.amos.boot.module.tcm.api.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;
import java.util.List;

/**
 * 事业单位注册
 */
@Data
@EqualsAndHashCode(callSuper = true)
@JsonInclude(JsonInclude.Include.NON_NULL)
public class BasePersonRegisterDto extends BaseDto {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "证件类型")
    private String credentialsType;

    @ApiModelProperty(value = "证件号码")
    private String credentialsNum;

    @ApiModelProperty(value = "真实姓名")
    private String realName;

    @JsonFormat(pattern="yyyy-MM-dd",timezone = "GMT+8")
    @ApiModelProperty(value = "有效期开始")
    private Date expirationDateStart;

    @JsonFormat(pattern="yyyy-MM-dd",timezone = "GMT+8")
    @ApiModelProperty(value = "有效期结束")
    private Date expirationDateEnd;

    @ApiModelProperty(value = "有效期类型")
    private String expirationDateType;



    @ApiModelProperty(value = "单位名称")
    private String name;

    @ApiModelProperty(value = "证件code")
    private String unitCode;

    @ApiModelProperty(value = "证件类型")
    private String unitCodeType;

    @ApiModelProperty(value = "证件类型名称")
    private String unitCodeTypeName;

    @ApiModelProperty(value = "单位类型")
    private List<String> unitTypeList;

    @ApiModelProperty(value = "单位类型code")
    private List<String> unitTypeCodeList;

    @ApiModelProperty(value = "管辖机构")
    private String managementUnit;

    @ApiModelProperty(value = "管辖单位id")
    private String managementUnitId;

    @ApiModelProperty(value = "管辖单位编码")
    private String managementUnitCompanyCode;

    @ApiModelProperty(value = "管辖单位orgCode")
    private String managementUnitOrgCode;


    @ApiModelProperty(value = "管理员用户名")
    private String adminLoginName;

    @ApiModelProperty(value = "管理员密码")
    private String adminLoginPwd;

    @ApiModelProperty(value = "管理员手机号")
    private String adminTel;

    @ApiModelProperty(value = "管理员身份证号")
    private String adminIdNumber;

//    @ApiModelProperty(value = "个人基本信息")
//    private TzsBaseIndividualityDto baseIndividualityDto;

    @ApiModelProperty(value = "平台公司id,平台创建公司后更新")
    private String amosCompanySeq;

    @ApiModelProperty(value = "平台用户id,平台创建用户后更新")
    private String adminUserId;

}
