package com.yeejoin.amos.boot.module.common.api.feign;

import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;

import com.yeejoin.amos.boot.biz.common.feign.MultipartSupportConfig;
import com.yeejoin.amos.component.feign.model.FeignClientResult;
/**
 * 
 * <pre>
 * 设备联动服务（车库门、广播、警铃）
 * </pre>
 *
 * @author gwb
 * @version $Id: JcsControlServerClient.java, v 0.1 2021年8月19日 上午9:41:10 gwb Exp $
 */
@FeignClient(name = "${control.fegin.name}", configuration = {MultipartSupportConfig.class})
public interface JcsControlServerClient {

	/**
	 * 
	 * <pre>
	 * 打开/关闭消防警铃
	 * </pre>
	 *
	 * @param areasStr
	 * @param type（1 为开启  0为关闭）
	 * @return
	 */
    @GetMapping(value = "/v1/wksendbell/{codestr}/{type}")
    FeignClientResult<String> sendBellAction(@PathVariable("codestr") String areasStr, @PathVariable("type") String type);
    
    /**
     * 
     * <pre>
     * 打开/关闭消防警铃(自动关闭时间单位为：秒)
     * </pre>
     *
     * @param areasStr
     * @param type
     * @param closttime
     * @return
     */
    @GetMapping(value = "/v1/wksendbell/{codestr}/{type}/{closttime}")
    FeignClientResult<String> sendBellActionWithTime(@PathVariable("codestr") String areasStr,
    		@PathVariable("type") String type,@PathVariable("closttime") long closttime);

   /**
    * 
    * <pre>
    * 播放广播
    * </pre>
    *
    * @param areasStr
    * @param fileUrlsStr
    * @return
    */
    @GetMapping(value = "/v1/wksend/{codestr}/{urlstr}")
    FeignClientResult<String> sendFileAction(@PathVariable("codestr") String areasStr,@PathVariable("urlstr") String fileUrlsStr);
    
    /**
     * 
     * <pre>
     * 获取单个设备状态(车库门)
     * </pre>
     *
     * @param ip
     * @param port
     * @param whichone
     * @return
     */
    @GetMapping(value = "/v1/controlequip/kndread/{ip}/{port}/{num}")
    FeignClientResult<String> readStateAction(@PathVariable("ip") String ip, @PathVariable("port") int port, 
    		@PathVariable("num") int whichone);
    
    /**
     * 
     * <pre>
     * 获取连续设备状态(车库门)
     * </pre>
     *
     * @param ip
     * @param port
     * @param whichone
     * @param count
     * @return
     */
    @GetMapping(value = "/v1/controlequip/kndread/{ip}/{port}/{num}/{count}")
    FeignClientResult<String> readMoreStateAction(@PathVariable("ip") String ip,@PathVariable("port") int port, 
    		@PathVariable("num") int whichone, @PathVariable("count") int count);
    
    /**
     * 
     * <pre>
     * 设置设备状态(车库门)
     * </pre>
     *
     * @param ip
     * @param port
     * @param whichone
     * @param stateStr
     * @return
     */
    @GetMapping(value = "/v1/controlequip/kndwrite/{ip}/{port}/{num}/{result}")
    FeignClientResult<String> writeStateAction(@PathVariable("ip") String ip,@PathVariable("port") int port, 
    		@PathVariable("num") int whichone, @PathVariable("result") String stateStr);
    

}
