package com.yeejoin.equipmanage.common.entity.dto;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.yeejoin.equipmanage.common.entity.Stock;
import com.yeejoin.equipmanage.common.entity.StockBill;
import com.yeejoin.equipmanage.common.entity.publics.BaseDTO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;

/**
 * 单据管理dto
 * @author ZeHua Li
 * @date 2020/8/28 10:53
 * @since v2.0
 */
@Data
@ApiModel(value = "StockBillDTO对象", description = "单据请求实体")
public class StockBillDTO extends BaseDTO<StockBill> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "单据编码")
    private String billCode;

    @ApiModelProperty(value = "单据类型")
    private String billType;

    @ApiModelProperty(value = "时间区间开始")
    private Date createDateStart;

    @ApiModelProperty(value = "时间区间结束")
    private Date createDateEnd;
}
