package com.yeejoin.amos.boot.module.common.biz.service.impl;

import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.google.common.collect.Lists;
import com.hikvision.artemis.sdk.ArtemisHttpUtil;
import com.hikvision.artemis.sdk.config.ArtemisConfig;
import com.yeejoin.amos.boot.biz.common.dto.CommonRegionDto;
import com.yeejoin.amos.boot.biz.common.dto.CommonVideoDto;
import com.yeejoin.amos.boot.biz.common.enums.CommonVideoEnum;
import com.yeejoin.amos.boot.module.common.api.dto.BaseEnterpriseVideoDto;
import com.yeejoin.amos.boot.module.common.api.entity.BaseEnterpriseVideo;
import com.yeejoin.amos.boot.module.common.api.entity.BaseEnterpriseVideoNode;
import com.yeejoin.amos.boot.module.common.api.enums.VideoIntegrationPlatformEnum;
import com.yeejoin.amos.boot.module.common.api.mapper.BaseEnterpriseVideoMapper;
import com.yeejoin.amos.boot.module.common.api.service.IBaseEnterpriseVideoService;
import com.yeejoin.amos.boot.module.common.api.utils.DateUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.conn.ConnectTimeoutException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;
import org.typroject.tyboot.core.rdbms.service.BaseService;

import java.net.URI;
import java.net.URISyntaxException;
import java.text.ParseException;
import java.util.*;
import java.util.stream.Collectors;

import static com.yeejoin.amos.boot.biz.common.constants.VideoConstant.CODE_200;

/**
 * 单位下摄像头表服务实现类
 *
 * @author system_generator
 * @date 2024-10-09
 */
@Service
@Slf4j
public class BaseEnterpriseVideoServiceImpl extends BaseService<BaseEnterpriseVideoDto, BaseEnterpriseVideo, BaseEnterpriseVideoMapper> implements IBaseEnterpriseVideoService {

    @Value("${cylinder.video.default.image.url:/upload/tzs/cylinder/no-connect.png}")
    private String defaultVideoUrl;

    private String rootIndexCode = "root00000000";
    @Autowired
    private BaseEnterpriseVideoNodeServiceImpl baseEnterpriseVideoNodeService;
    public List<CommonVideoDto> getUnitVideoUrl(String useUnitCode, String regionCode) {
        List<CommonVideoDto> result = new ArrayList<>();
        LambdaQueryWrapper<BaseEnterpriseVideo> wrapper = new LambdaQueryWrapper<>();
        //wrapper.eq(BaseEnterpriseVideo::getUseUnitCode, useUnitCode);
        wrapper.eq(BaseEnterpriseVideo::getIsEnabled, true);
        //wrapper.like(StringUtils.isNotEmpty(regionCode), BaseEnterpriseVideo::getRegionCode, regionCode);
        List<BaseEnterpriseVideo> videos = this.getBaseMapper().selectList(wrapper);
        if (ValidationUtil.isEmpty(videos)) {
            return result;
        }
        // 将videos按对接平台字段分组，并存放Map<String, List<BaseEnterpriseVideo>>中
        Map<String, List<BaseEnterpriseVideo>> map = videos.stream().collect(Collectors.groupingBy(BaseEnterpriseVideo::getPlatform));
        map.forEach((key, value) -> {
            if (VideoIntegrationPlatformEnum.YS.getCode().equals(key)) {
                getYsVideoUrl(value, result);
            }
            if (VideoIntegrationPlatformEnum.ISECURECENTER.getCode().equals(key)) {
                value.stream().forEach(baseEnterpriseVideo -> {
                    LambdaQueryWrapper<BaseEnterpriseVideoNode> wrappers = new LambdaQueryWrapper<>();
                    wrappers.eq(BaseEnterpriseVideoNode::getVideoSeq, baseEnterpriseVideo.getSequenceNbr());
                    wrappers.eq(BaseEnterpriseVideoNode::getUseUnitCode, useUnitCode);
                    wrappers.like(StringUtils.isNotEmpty(regionCode), BaseEnterpriseVideoNode::getRegionCode, regionCode);
                    List<BaseEnterpriseVideoNode> videoNodes = baseEnterpriseVideoNodeService.list(wrappers);
                    getISecureCenterVideoUrl(videoNodes,baseEnterpriseVideo, result);
                        });
            }
        });

        return result;
    }

    private void getISecureCenterVideoUrl(List<BaseEnterpriseVideoNode> videoNodes,BaseEnterpriseVideo baseEnterpriseVideo,List<CommonVideoDto> videoUrlResult) {
        List<CommonVideoDto> videoList = getISecureCenterCameras(videoNodes);
        if (ValidationUtil.isEmpty(videoList)) {
            return;
        }
//        BaseEnterpriseVideo baseEnterpriseVideo = videos.get(0);
        videoList.forEach(video -> {
            List<CommonVideoDto> commonVideoDtos = new ArrayList<>();
            try {
                Map<String, Object> artemisInfo = initArtemisConfigAndPath(baseEnterpriseVideo, baseEnterpriseVideo.getUrl());
                ArtemisConfig config = (ArtemisConfig) artemisInfo.get("config");
                Map<String, String> path = (Map<String, String>) artemisInfo.get("path");

                JSONObject param = JSONObject.parseObject(baseEnterpriseVideo.getChannelNo());// post请求Form表单参数
                param.put("cameraIndexCode", video.getKey());
                String body = param.toJSONString();
                String resultStr = ArtemisHttpUtil.doPostStringArtemis(config, path, body, null, null, "application/json", null);
                if (ValidationUtil.isEmpty(resultStr)) {
                    return;
                }
                JSONObject result = JSONObject.parseObject(resultStr);
                if (!result.get("code").equals("0")) {
                    log.error("获取iSecureCenter视频对接平台摄像头预览url失败,code:{}", result.get("code"));
                }
                if (result.get("data") == null) {
                    return;
                }
                if (result.get("data") instanceof JSONObject) {
                    JSONObject dataObj = (JSONObject) result.get("data");
                    String cameraUrl = dataObj.getString("url");
                    video.setUrl(cameraUrl);
                    video.setType(param.getString("viewProtocol"));
                }
            } catch (URISyntaxException e) {
                throw new RuntimeException("URL格式解析异常", e);
            } catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
        videoUrlResult.addAll(videoList);
    }

    /**
     * 解析URL字符串为协议、主机+端口和路径部分
     *
     * @param url 完整的URL字符串
     * @return 包含 protocol, hostPort 和 urlPath 的Map
     */
    private Map<String, String> parseUri(String url) throws URISyntaxException {
        // 将url解析为https://192.168.1.1:8080/api/v1?pageNo=1&pageSize=20这种方式
        URI uri = new URI(url);
        String scheme = uri.getScheme();
        String protocol = scheme != null ? scheme + "://" : "";
        String hostPort = uri.getHost() + (uri.getPort() != -1 ? ":" + uri.getPort() : "");
        String urlPath = uri.getPath();

        Map<String, String> result = new HashMap<>();
        result.put("protocol", protocol);
        result.put("hostPort", hostPort);
        result.put("urlPath", urlPath);
        return result;
    }

    /**
     * 初始化Artemis配置和路径信息
     *
     * @param baseEnterpriseVideo 视频设备信息
     * @param apiUrl
     * @return 包含 ArtemisConfig、请求路径和协议的Map
     */
    private Map<String, Object> initArtemisConfigAndPath(BaseEnterpriseVideo baseEnterpriseVideo, String apiUrl) throws URISyntaxException {
        Map<String, String> uriInfo = parseUri(apiUrl);
        String protocol = uriInfo.get("protocol");
        String hostPort = uriInfo.get("hostPort");
        String urlPath = uriInfo.get("urlPath");

        ArtemisConfig config = new ArtemisConfig();
        config.setAppKey(baseEnterpriseVideo.getAppKey());
        config.setAppSecret(baseEnterpriseVideo.getAppSecret());
        config.setHost(hostPort);

        Map<String, String> path = new HashMap<>();
        path.put(protocol, urlPath);

        Map<String, Object> result = new HashMap<>();
        result.put("config", config);
        result.put("path", path);
        return result;
    }

    private void getYsVideoUrl(List<BaseEnterpriseVideo> videos, List<CommonVideoDto> result) {
        for (BaseEnterpriseVideo video : videos) {
            Map<String, Object> requestInfo = new HashMap<>();
            requestInfo.put("appKey", video.getAppKey());
            requestInfo.put("appSecret", video.getAppSecret());
            String channelNos = video.getChannelNo();
            List<CommonVideoDto> channelNoList = JSONObject.parseArray(channelNos, CommonVideoDto.class);
            try {
                String accessTokenData = HttpUtil.post(video.getTokenUrl(), requestInfo);
                JSONObject jsonObject = JSON.parseObject(accessTokenData);
                String msg = jsonObject.get("msg").toString();
                String code = jsonObject.get("code").toString();
                if (CODE_200.equals(code)) {
                    String data = jsonObject.get("data").toString();
                    JSONObject objTokenJson = JSON.parseObject(data);
                    String accessToken = objTokenJson.get("accessToken").toString();
                    System.out.println(accessToken);
                    for (CommonVideoDto channelNo : channelNoList) {
                        Map<String, Object> requestVideosInfo = new HashMap<>();
                        requestVideosInfo.put("accessToken", accessToken);
                        requestVideosInfo.put("deviceSerial", video.getDeviceSerial());
                        requestVideosInfo.put("channelNo", channelNo.getKey());
                        requestVideosInfo.put("protocol", video.getProtocol());
                        requestVideosInfo.put("quality", channelNo.getQuality());
                        requestVideosInfo.put("supportH265", channelNo.getSupportH265());
                        requestVideosInfo.put("expireTime", video.getExpireTime());
                        log.info("开始获取通道信息：{}", JSONObject.toJSONString(requestVideosInfo));
                        String videoData = HttpUtil.post(video.getUrl(), requestVideosInfo);
                        JSONObject videoJsonObject = JSON.parseObject(videoData);
                        String msgVideo = videoJsonObject.get("msg").toString();
                        String codeVideo = videoJsonObject.get("code").toString();
                        if (CODE_200.equals(codeVideo)) {
                            String dataS = videoJsonObject.get("data").toString();
                            JSONObject dd = JSON.parseObject(dataS);
                            String url = dd.get("url").toString();
                            channelNo.setUrl(url);
                            channelNo.setType(CommonVideoEnum.getEnum(video.getProtocol()).getName());
                            result.add(channelNo);
                        } else {
                            String errorMsg = "code:" + codeVideo + "msg:" + msgVideo + "appKey:" + video.getAppKey() + "appSecret:" + video.getAppSecret() + "accessToken:" + accessToken;
                            log.info("视频地址获取失败errorMsg:{}", errorMsg);
                            this.setDefaultChannelData(result, channelNo);
                        }
                    }
                } else {
                    String errorMsg = "code:" + code + "msg:" + msg + "appKey:" + video.getAppKey() + "appSecret:" + video.getAppSecret();
                    log.info("视频token获取失败errorMsg:{}", errorMsg);
                    this.setDefaultVideoIfConnectFailed(channelNoList, result);
                }
            } catch (Exception e) {
                log.error(e.getMessage());
                this.setDefaultVideoIfConnectFailed(channelNoList, result);
            }
        }
    }

    /**
     * 通道连接不上时，返回通道的默认图片
     *
     * @param result    返回连接的总通道
     * @param channelNo 未连接的通道
     */
    private void setDefaultChannelData(List<CommonVideoDto> result, CommonVideoDto channelNo) {
        CommonVideoDto commonVideoDto = new CommonVideoDto();
        commonVideoDto.setUrl(channelNo.getThumb());
        commonVideoDto.setKey(channelNo.getKey());
        commonVideoDto.setType(CommonVideoEnum.IMG.getName());
        commonVideoDto.setTitle(channelNo.getTitle());
        commonVideoDto.setThumb(channelNo.getThumb());
        result.add(commonVideoDto);
    }

    /**
     * 连接不上时返回的气通道信息
     *
     * @param commonVideoDtos 当前气瓶单位的所有通道
     * @param result          返回的结果集合
     */
    private void setDefaultVideoIfConnectFailed(List<CommonVideoDto> commonVideoDtos, List<CommonVideoDto> result) {
        // 先情况防止数据重复
        result.clear();
        // 每个通道设备默认值
        commonVideoDtos.forEach(channelNo -> this.setDefaultChannelData(result, channelNo));
    }

    public List<CommonVideoDto> getISecureCenterCameras(List<BaseEnterpriseVideoNode> videoNodesList) {
//        List<BaseEnterpriseVideo> iSecureCenterVideoList = videoEquipList.stream().filter(v -> VideoIntegrationPlatformEnum.ISECURECENTER.getCode().equals(v.getPlatform())).collect(Collectors.toList());
//        if (!ValidationUtil.isEmpty(iSecureCenterVideoList)) {
//            // 根据iSecureCenter视频对接平台，直接获取摄像头列表
//            return getRegionCameras(iSecureCenterVideoList);
//        }
        List<CommonVideoDto> commonVideoDtos = new ArrayList<>();
        videoNodesList.stream().forEach(baseEnterpriseVideoNode -> {
            CommonVideoDto commonVideoDto = new CommonVideoDto();
            commonVideoDto.setKey(baseEnterpriseVideoNode.getCameraIndexCode());
            commonVideoDto.setLabel(baseEnterpriseVideoNode.getVideoName());
            commonVideoDto.setTitle(baseEnterpriseVideoNode.getVideoName());
            commonVideoDto.setParent(baseEnterpriseVideoNode.getUseUnitCode());
            commonVideoDto.setUseRegistrationCode(baseEnterpriseVideoNode.getDevUseCode());
            commonVideoDtos.add(commonVideoDto);
        });
        return commonVideoDtos;
    }

    /**
     * iSecureCenter视频对接平台，根据区域ID（企业统一信用代码唯一对应）获取摄像头列表。
     * 现有对接一个企业只有一条数据，取第一条数据作为企业信息。
     *
     * @param iSecureCenterVideoList 企业列表
     * @return List<CommonVideoDto>
     */
    private List<CommonVideoDto> getRegionCameras(List<BaseEnterpriseVideo> iSecureCenterVideoList) {
        List<CommonVideoDto> commonVideoDtos = new ArrayList<>();
        BaseEnterpriseVideo baseEnterpriseVideo = iSecureCenterVideoList.get(0);
        try {
            Map<String, Object> artemisInfo = initArtemisConfigAndPath(baseEnterpriseVideo, baseEnterpriseVideo.getTokenUrl());
            ArtemisConfig config = (ArtemisConfig) artemisInfo.get("config");
            Map<String, String> path = (Map<String, String>) artemisInfo.get("path");

            Map<String, String> paramMap = new HashMap<>();// post请求Form表单参数
            paramMap.put("regionIndexCode", baseEnterpriseVideo.getDeviceSerial());
            paramMap.put("pageNo", "1");
            paramMap.put("pageSize", "100");
            String body = JSON.toJSON(paramMap).toString();
            String resultStr = ArtemisHttpUtil.doPostStringArtemis(config, path, body, null, null, "application/json", null);
            if (ValidationUtil.isEmpty(resultStr)) {
                return null;
            }
            JSONObject result = JSONObject.parseObject(resultStr);
            if (!result.get("code").equals("0")) {
                log.error("获取iSecureCenter视频对接平台摄像头列表失败,code:{}", result.get("code"));
                return commonVideoDtos;
            }
            if (result.get("data") == null) {
                return commonVideoDtos;
            }
            if (result.get("data") instanceof JSONObject) {
                JSONObject dataObj = (JSONObject) result.get("data");
                JSONArray dataList = dataObj.getJSONArray("list");
                if (ValidationUtil.isEmpty(dataList)) {
                    return commonVideoDtos;
                }
                dataList.forEach(data -> {
                    CommonVideoDto commonVideoDto = new CommonVideoDto();
                    JSONObject dataJson = (JSONObject) data;
                    /* dataJson返回结果样例
                    {"regionIndexCode":"cac9325d1ac74415b064a621595f6e09","capabilitySetName":"GPS事件能力,视频事件能力,IO能力,视频能力,录像能力,视频设备远程获取能力,设备维护能力,客流统计事件能力,状态能力","channelNo":"3","latitude":"34.4765399909899","channelType":"digital","cameraIndexCode":"9215c9a92f574a7da23523ef6894c5a2","recordLocation":"1","cameraTypeName":"xres.query.camera.type.qj","recordLocationName":"xres.query.device.store","channelTypeName":"xres.query.camera.digital","transTypeName":"TCP","cameraName":"迂回站上车区","longitude":"108.9768070075236","installLocation":"索12陕J00001(21)","updateTime":"2025-08-20T10:44:56.273+08:00","gbIndexCode":"61000000001310257002","cameraType":0,"transType":1,"createTime":"2025-04-07T11:16:01.258+08:00","capabilitySet":"event_gps,event_vss,io,vss,record,remote_vss,maintenance,event_pdc,status","encodeDevIndexCode":"94dddc8ed1124f8c9cd9537beb12ef72"}
                     */
                    commonVideoDto.setKey(dataJson.getString("cameraIndexCode"));
                    commonVideoDto.setLabel(dataJson.getString("cameraName"));
                    commonVideoDto.setTitle(dataJson.getString("cameraName"));
                    commonVideoDto.setParent(baseEnterpriseVideo.getUseUnitCode());
                    commonVideoDto.setUseRegistrationCode(dataJson.getString("installLocation"));
                    commonVideoDtos.add(commonVideoDto);
                });
                return commonVideoDtos;
            }
        } catch (URISyntaxException e) {
            throw new RuntimeException("URL格式解析异常", e);
        } catch (ConnectTimeoutException e) {
            log.error("获取iSecureCenter视频对接平台超时:{}", e.getLocalizedMessage(), e);
            return commonVideoDtos;
        } catch (Exception e) {
            log.error("获取iSecureCenter视频对接平台摄像头列表失败，未知错误！", e);
            return commonVideoDtos;
        }
        return commonVideoDtos;
    }

    /**
     * 根据编号获取区域详细信息
     */
    @Transactional(rollbackFor = Exception.class)
    public List<CommonRegionDto> getAllRegionInfo(String regionCode) {
        List<BaseEnterpriseVideo> allRegionList = Lists.newArrayList();
        BaseEnterpriseVideo baseEnterpriseVideo = new BaseEnterpriseVideo();
        baseEnterpriseVideo.setAppKey("26245828");
        baseEnterpriseVideo.setAppSecret("zzZ3KPeIRFU8PZkHSwVp");
        baseEnterpriseVideo.setTokenUrl("https://113.140.67.204:55443/artemis/api/resource/v1/regions/subRegions");
        final List<CommonRegionDto> commonRegionList = getCommonRegionList(baseEnterpriseVideo, rootIndexCode);
        if (!ValidationUtil.isEmpty(commonRegionList)) {
            commonRegionList.forEach(region -> {
                BaseEnterpriseVideo enterpriseVideo = new BaseEnterpriseVideo();
                enterpriseVideo.setAppKey(baseEnterpriseVideo.getAppKey());
                enterpriseVideo.setAppSecret(baseEnterpriseVideo.getAppSecret());
                enterpriseVideo.setTokenUrl("https://113.140.67.204:55443/artemis/api/resource/v1/regions/regionIndexCode/cameras?pageNo=1&pageSize=20");
                enterpriseVideo.setUrl("https://113.140.67.204:55443/artemis/api/video/v2/cameras/previewURLs");
                enterpriseVideo.setDeviceSerial(region.getIndexCode());
                enterpriseVideo.setProtocol("2");
                enterpriseVideo.setChannelNo("{\"streamType\":0,\"protocol\":\"hls\",\"transmode\":\"1\",\"viewProtocol\":\"hlsHk\"}");
                enterpriseVideo.setExpireTime(60480000L);
                enterpriseVideo.setUseUnitCode(region.getUseUnitCode());
                enterpriseVideo.setIsEnabled(true);
                enterpriseVideo.setPlatform("iSecureCenter");
                enterpriseVideo.setRecDate(new Date());
                allRegionList.add(enterpriseVideo);
            });
        }
        this.saveOrUpdateBatch(allRegionList);
        return commonRegionList;
    }

    private List<CommonRegionDto> getCommonRegionList(BaseEnterpriseVideo baseEnterpriseVideo, String regionCode) {
        Map<String, Object> artemisInfo;
        List<CommonRegionDto> commonRegionList = new ArrayList<>();
        try {
            artemisInfo = initArtemisConfigAndPath(baseEnterpriseVideo, baseEnterpriseVideo.getTokenUrl());
            ArtemisConfig config = (ArtemisConfig) artemisInfo.get("config");
            Map<String, String> path = (Map<String, String>) artemisInfo.get("path");
            Map<String, String> paramMap = new HashMap<>();// post请求Form表单参数
            paramMap.put("parentIndexCode", "cac9325d1ac74415b064a621595f6e09");
            String body = JSON.toJSON(paramMap).toString();
            String resultStr = ArtemisHttpUtil.doPostStringArtemis(config, path, body, null, null, "application/json", null);
            if (ValidationUtil.isEmpty(resultStr)) {
                return null;
            }
            JSONObject result = JSONObject.parseObject(resultStr);
            if (!result.get("code").equals("0")) {
                log.error("getRegionInfo列表失败,code:{}", result.get("code"));
            }
            if (result.get("data") instanceof JSONArray) {
                JSONArray dataObj = (JSONArray) result.get("data");
                if (!ValidationUtil.isEmpty(dataObj)) {
                    dataObj.forEach(data -> {
                        CommonRegionDto commonRegionDto = new CommonRegionDto();
                        JSONObject dataJson = (JSONObject) data;
                        commonRegionDto.setIndexCode(dataJson.getString("indexCode"));
                        commonRegionDto.setParentIndexCode(dataJson.getString("parentIndexCode"));
                        commonRegionDto.setUseUnitCode(dataJson.getString("name"));
                        commonRegionList.add(commonRegionDto);
                    });
                }
            }
        } catch (URISyntaxException e) {
            throw new RuntimeException(e);
        } catch (Exception e) {
            log.error("获取iSecureCenter视频对接平台区域列表失败，未知错误！", e);
            throw new RuntimeException(e);
        }
        return commonRegionList;
    }

    public boolean saveOrUpdateVideos(String sequenceNbr) throws Exception {
        BaseEnterpriseVideo baseEnterpriseVideo = this.getBaseMapper().selectById(sequenceNbr);
        String appKey = baseEnterpriseVideo.getAppKey();
        String appSecret = baseEnterpriseVideo.getAppSecret();
        String deviceSerial = baseEnterpriseVideo.getDeviceSerial();
        String url = "https://113.140.67.204:55443/artemis/api/resource/v1/regions/subRegions";
        String videoUrl = "https://113.140.67.204:55443/artemis/api/resource/v1/regions/regionIndexCode/cameras";
        //根据跟节点673f784dc4ae4cf681957386accd445c获取区域列表子节点 开始
        String regionsStr = getsubRegions(appKey, appSecret, url, deviceSerial);
        if (ValidationUtil.isEmpty(regionsStr)) {
            log.error("获取iSecureCenter视频对接平台区域列表失败,deviceSerial:{}", deviceSerial);
            return false;
        }
        JSONObject regionsResult = JSONObject.parseObject(regionsStr);
        if (regionsResult.get("data") == null) {
            log.error("获取iSecureCenter视频对接平台区域列表失败,data:{}", regionsStr);
            return false;
        }
        JSONArray regionsDataList = regionsResult.getJSONArray("data");
        if (ValidationUtil.isEmpty(regionsDataList)) {
            log.error("获取iSecureCenter视频对接平台区域列表失败,regionsDataList:{}", regionsDataList);
            return false;
        } else {
            regionsDataList.forEach(regionsData -> {
                JSONObject regionDataJson = (JSONObject) regionsData;
                String regionName = regionDataJson.getString("name");
                String regionIndexCode = regionDataJson.getString("indexCode");

                //根据区域regionIndexCode获取企业列表 开始
                String unitsStr = getsubRegions(appKey, appSecret, url, regionIndexCode);
                if (ValidationUtil.isEmpty(unitsStr)) {
                    log.error("获取iSecureCenter视频对接平台区域列表失败,deviceSerial:{}", regionIndexCode);
                }
                JSONObject unitsResult = JSONObject.parseObject(unitsStr);
                if (unitsResult.get("data") == null) {
                    log.error("获取iSecureCenter视频对接平台区域列表失败,data:{}", unitsStr);
                }
                JSONArray unitsDataList = unitsResult.getJSONArray("data");
                if (ValidationUtil.isEmpty(unitsDataList)) {
                    log.error("获取iSecureCenter视频对接平台区域列表失败,regionsDataList:{}", unitsDataList);
                } else {
                    unitsDataList.forEach(unitsData -> {
                        JSONObject unitDataJson = (JSONObject) unitsData;
                        String unitNameAndCode = unitDataJson.getString("name");
                        String unitName = unitNameAndCode==null?"":unitNameAndCode.split("#")[0];
                        String unitCode = unitNameAndCode==null?"":(unitNameAndCode.contains("#")?unitNameAndCode.split("#")[1]:"");

                        String unitIndexCode = unitDataJson.getString("indexCode");
                        //根据单位unitIndexCode获取设备列表 开始
                        String devsStr = getsubRegions(appKey, appSecret, url, unitIndexCode);
                        if (ValidationUtil.isEmpty(devsStr)) {
                            log.error("获取iSecureCenter视频对接平台设备列表失败,deviceSerial:{}", unitIndexCode);
                        }
                        JSONObject devsResult = JSONObject.parseObject(devsStr);
                        if (devsResult.get("data") == null) {
                            log.error("获取iSecureCenter视频对接平台设备列表失败,data:{}", devsStr);
                        }
                        JSONArray devsDataList = devsResult.getJSONArray("data");
                        if (ValidationUtil.isEmpty(devsDataList)) {
                            log.error("获取iSecureCenter视频对接平台设备列表失败,regionsDataList:{}", devsDataList);
                        } else {
                            devsDataList.forEach(devsData -> {
                                JSONObject devDataJson = (JSONObject) devsData;
                                String devName = devDataJson.getString("name");
                                String devIndexCode = devDataJson.getString("indexCode");
                                String camerasStr = getCameras(appKey, appSecret, videoUrl, devIndexCode);
                                if (ValidationUtil.isEmpty(camerasStr)) {
                                    log.error("获取iSecureCenter视频对接平台区域列表失败,deviceSerial:{}", deviceSerial);
                                }
                                JSONObject camerasResult = JSONObject.parseObject(camerasStr);
                                if (camerasResult.get("data") == null) {
                                    log.error("获取iSecureCenter视频对接平台区域列表失败,data:{}", camerasStr);
                                }
                                JSONObject camerasDataList = (JSONObject) camerasResult.get("data");
//                                JSONObject dataObj = (JSONObject) result.get("data");
                                JSONArray cameraDataList = camerasDataList.getJSONArray("list");
                                if (ValidationUtil.isEmpty(camerasDataList)) {
                                    log.error("获取iSecureCenter视频对接平台区域列表失败,regionsDataList:{}", camerasDataList);
                                } else {
                                    cameraDataList.forEach(cameraData -> {
                                        JSONObject cameraDataJson = (JSONObject) cameraData;
                                        String cameraName = cameraDataJson.getString("cameraName");
                                        String useInstallCode = cameraDataJson.getString("installLocation");
                                        String reIndexCode = cameraDataJson.getString("regionIndexCode");
                                        String cameraIndexCode = cameraDataJson.getString("cameraIndexCode");
                                        String updateTime = cameraDataJson.getString("updateTime");
                                        String createTime = cameraDataJson.getString("createTime");
                                        BaseEnterpriseVideoNode enterpriseVideoNode = new BaseEnterpriseVideoNode();
                                        enterpriseVideoNode.setUseUnitName(unitName);
                                        enterpriseVideoNode.setUseUnitCode(unitCode);
                                        enterpriseVideoNode.setRegionCode(reIndexCode);
                                        enterpriseVideoNode.setVideoName(cameraName);
                                        enterpriseVideoNode.setDevUseCode(useInstallCode);
                                        enterpriseVideoNode.setIsDelete(true);
                                        enterpriseVideoNode.setCameraIndexCode(cameraIndexCode);
                                        try {
                                            enterpriseVideoNode.setRecDate(DateUtils.dateParseWithPattern(createTime));
                                            enterpriseVideoNode.setUpdatesTime(DateUtils.dateParseWithPattern(updateTime));
                                        } catch (ParseException e) {
                                            throw new RuntimeException(e);
                                        }
                                        baseEnterpriseVideoNodeService.saveOrUpdate(enterpriseVideoNode, new QueryWrapper<BaseEnterpriseVideoNode>().lambda().eq(BaseEnterpriseVideoNode::getCameraIndexCode, cameraIndexCode));
                                    });
                                }
                            });
                        }
                    });
                }
            });
        }

        return true;
    }

    public String getsubRegions(String appKey, String appSecret, String apiUrl, String indexCode) {

        Map<String, String> uriInfo = null;
        try {
            uriInfo = parseUri(apiUrl);
        } catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        String protocol = uriInfo.get("protocol");
        String hostPort = uriInfo.get("hostPort");
        String urlPath = uriInfo.get("urlPath");
        Map<String, String> path = new HashMap<>();
        path.put(protocol, urlPath);
        ArtemisConfig config = new ArtemisConfig();
        config.setAppKey(appKey);
        config.setAppSecret(appSecret);
        config.setHost(hostPort);
        Map<String, String> paramMap = new HashMap<>();// post请求Form表单参数
        paramMap.put("parentIndexCode", indexCode);
        String body = JSON.toJSON(paramMap).toString();
        try {
            return ArtemisHttpUtil.doPostStringArtemis(config, path, body, null, null, "application/json", null);
        } catch (Exception e) {
            log.error("获取iSecureCenter视频对接平台区域列表失败,deviceSerial:{}", indexCode);
            throw new RuntimeException(e);
        }
    }

    public String getCameras(String appKey, String appSecret, String apiUrl, String indexCode) {

        Map<String, String> uriInfo = null;
        try {
            uriInfo = parseUri(apiUrl);
        } catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        String protocol = uriInfo.get("protocol");
        String hostPort = uriInfo.get("hostPort");
        String urlPath = uriInfo.get("urlPath");
        Map<String, String> path = new HashMap<>();
        path.put(protocol, urlPath);
        ArtemisConfig config = new ArtemisConfig();
        config.setAppKey(appKey);
        config.setAppSecret(appSecret);
        config.setHost(hostPort);
        Map<String, String> paramMap = new HashMap<>();// post请求Form表单参数
        paramMap.put("regionIndexCode", indexCode);
        paramMap.put("pageNo", "1");
        paramMap.put("pageSize", "1000");
        String body = JSON.toJSON(paramMap).toString();
        try {
            return ArtemisHttpUtil.doPostStringArtemis(config, path, body, null, null, "application/json", null);
        } catch (Exception e) {
            log.error("获取iSecureCenter视频对接平台区域列表失败,deviceSerial:{}", indexCode);
            throw new RuntimeException(e);
        }
    }
}