package com.yeejoin.amos.boot.module.jg.biz.reminder.biz.vehicleInformation;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.yeejoin.amos.boot.module.jg.api.dto.ReminderItemDto;
import com.yeejoin.amos.boot.module.jg.api.entity.JgVehicleInformation;
import com.yeejoin.amos.boot.module.jg.api.entity.JgVehicleInformationEq;
import com.yeejoin.amos.boot.module.jg.api.enums.BusinessTypeEnum;
import com.yeejoin.amos.boot.module.jg.biz.reminder.core.DefaultReminder;
import com.yeejoin.amos.boot.module.jg.biz.reminder.dto.MatchItemDto;
import com.yeejoin.amos.boot.module.jg.biz.reminder.service.CommonReminderService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import static com.yeejoin.amos.boot.module.jg.biz.service.impl.CommonServiceImpl.SECOND;
import static com.yeejoin.amos.boot.module.jg.biz.service.impl.CommonServiceImpl.notice;

/**
 * 使用登记-提醒处理器
 */
@Component
public class VehicleInformationReminderAdapter extends DefaultReminder {

    private final VehicleInformationReminderParse vehicleInformationReminderParse;

    public VehicleInformationReminderAdapter(ApplicationContext applicationContext, VehicleInformationReminderParse vehicleInformationReminderParse) {
        super(applicationContext);
        this.vehicleInformationReminderParse = vehicleInformationReminderParse;
    }

    @Override
    public List<ReminderItemDto> realtimeParse(String bizId) {
        //  创建后, 监管通过时使用
        JgVehicleInformation vehicleInformation = vehicleInformationReminderParse.getVehicleInformationMapper().selectById(bizId);
        LambdaQueryWrapper<JgVehicleInformationEq> lambda = new QueryWrapper<JgVehicleInformationEq>().lambda();
        lambda.eq(JgVehicleInformationEq::getVehicleId, vehicleInformation.getSequenceNbr());
        lambda.select(JgVehicleInformationEq::getEquId);
        List<String> records = vehicleInformationReminderParse.getVehicleInformationEqMapper().selectList(lambda).stream().map(JgVehicleInformationEq::getEquId).collect(Collectors.toList());
        List<ReminderItemDto> itemDtoList = vehicleInformationReminderParse.getVehicleInformationMapper().queryUnitVehiclesForReminderList(records);
        itemDtoList.forEach(item -> item.setDetailData(this.buildCompareData(vehicleInformation, item.getEquipId())));
        return itemDtoList;
    }


    private Map<String, Object> buildCompareData(JgVehicleInformation vehicleInformation, String record) {
        Map<String, Object> re = BeanUtil.beanToMap(vehicleInformation);
        re.putAll(vehicleInformationReminderParse.getEquipDetailByRecord(record));
        return re;
    }

    private Map<String, Object> buildCompareData(Map<String, Object> vehicleInformation, String record) {
        Map<String, Object> re = BeanUtil.beanToMap(vehicleInformation);
        re.putAll(vehicleInformationReminderParse.getEquipDetailByRecord(record));
        return re;
    }


    @Override
    public List<ReminderItemDto> jsonParse(String bizId, Map<String, Object> formData) {
        // 气瓶--气瓶分页
        JSONObject data = getSummitDataFromJson(formData);
        List<Map<String, Object>> equipmentLists = (List<Map<String, Object>>) data.get("equipmentLists");
        List<String> records = equipmentLists.stream().map(item -> item.get("record").toString()).collect(Collectors.toList());
        List<ReminderItemDto> mapPage = vehicleInformationReminderParse.getVehicleInformationMapper().queryUnitVehiclesForReminderList(records);
        mapPage.forEach(item -> item.setDetailData(this.buildCompareData(data, item.getEquipId())));
        return mapPage;
    }

    private static JSONObject getSummitDataFromJson(Map<String, Object> formData) {
        JSONObject data;
        //  新增 + 编辑的保存使用
        if (formData.containsKey(notice)) { // 新增登记工作台发起
            data = JSONObject.parseObject(JSONObject.toJSONString(formData.get(notice)));
            data.put("regType", "0");
        } else if (formData.containsKey(SECOND)) { // 历史有证、无证登记
            data = JSONObject.parseObject(JSONObject.toJSONString(formData.get(SECOND)));
            data.put("regType", "1");
        } else {                                 //  编辑
            data = new JSONObject(formData);
        }
        return data;
    }

    @Override
    public MatchItemDto setMatchItem(String bizId, Map<String, Object> formData) {
        // 新增 + 编辑的保存并提交使用
        MatchItemDto matchItemDto = MatchItemDto.builder().build();
        JSONObject data = getSummitDataFromJson(formData);
        String record = CommonReminderService.getOneRecord(data);
        vehicleInformationReminderParse.getCommonReminderService().setMatchItemEquCategoryByRecord(matchItemDto, record);
        matchItemDto.setRegType(data.getString("regType"));
        matchItemDto.setWhetherVehicleCylinder("1");
        return matchItemDto;
    }

    @Override
    public MatchItemDto setMatchItem(String bizId) {
        // 评分 + 详情(通过按钮)使用
        JgVehicleInformation vehicleInformation = vehicleInformationReminderParse.getVehicleInformationMapper().selectById(bizId);
        MatchItemDto matchItemDto = MatchItemDto.builder().build();
        matchItemDto.setRegType(StringUtils.isEmpty(vehicleInformation.getRegType()) ? "0" : vehicleInformation.getRegType());
        // 气瓶
        setEquCategoryByOneRecord(vehicleInformation, matchItemDto);
        matchItemDto.setWhetherVehicleCylinder("1");
        return matchItemDto;
    }

    private void setEquCategoryByOneRecord(JgVehicleInformation vehicleInformation, MatchItemDto matchItemDto) {
        LambdaQueryWrapper<JgVehicleInformationEq> lambda = new QueryWrapper<JgVehicleInformationEq>().lambda();
        lambda.eq(JgVehicleInformationEq::getVehicleId, vehicleInformation.getSequenceNbr());
        lambda.select(JgVehicleInformationEq::getEquId);
        List<JgVehicleInformationEq> eqList = vehicleInformationReminderParse.getVehicleInformationEqMapper().selectList(lambda);
        String record = eqList.iterator().next().getEquId();
        vehicleInformationReminderParse.getCommonReminderService().setMatchItemEquCategoryByRecord(matchItemDto, record);
    }

    @Override
    public String supportBizType() {
        return BusinessTypeEnum.JG_VEHICLE_GAS_APPLICATION.name();
    }
}
