package com.yeejoin.amos.boot.module.jyjc.api.model;

import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.extension.handlers.FastjsonTypeHandler;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.yeejoin.amos.boot.module.common.api.dto.AttachmentDto;
import com.yeejoin.amos.boot.module.common.api.dto.BaseEnterpriseCertDto;
import com.yeejoin.amos.boot.module.ymt.api.vo.TzsUserInfoVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.typroject.tyboot.core.rdbms.model.BaseModel;

import java.util.Date;
import java.util.List;

/**
 * @author system_generator
 * @date 2023-12-13
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "JyjcOpeningApplicationModel", description = "")
public class JyjcOpeningApplicationModel extends BaseModel {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "单位编码")
    private String unitCode;
    @ApiModelProperty(value = "单位地址")
    private String unitAddress;

    @ApiModelProperty(value = "单位编码Name")
    private String unitCodeName;

    @ApiModelProperty(value = "检测区域编码")
    @TableField(value = "detection_region", typeHandler = FastjsonTypeHandler.class)
    private List<String> detectionRegion;

    @ApiModelProperty(value = "检测区域名称（冗余）")
    private String detectionRegionName;

    @ApiModelProperty(value = "申请单号")
    private String applicationSeq;

    @Deprecated
    @ApiModelProperty(value = "检验结果方式")
    private String resultType;

    @ApiModelProperty(value = "有效期至")
    @JsonFormat(pattern = "yyyy-MM-dd")
    private Date expiryDate;

    @ApiModelProperty(value = "受理日期（接收日期）")
    @JsonFormat(pattern = "yyyy-MM-dd")
    private Date acceptDate;

    @ApiModelProperty(value = "状态")
    private String status;

    @Deprecated
    @ApiModelProperty(value = "状态Name")
    private String statusName;

    @ApiModelProperty(value = "备注")
    private String remark;

    @ApiModelProperty(value = "申请时间")
    @JsonFormat(pattern = "yyyy-MM-dd")
    private Date applyTime;

    @ApiModelProperty(value = "工作流执行角色")
    private String workflowRole;

    @ApiModelProperty(value = "工作流实例ID")
    private String workflowProstanceId;

    @ApiModelProperty(value = "工作流节点")
    private String workflowActiveKey;

    @ApiModelProperty(value = "下一执行节点ids")
    private String nextExecuteIds;

    @ApiModelProperty(value = "发起人id用于撤回操作")
    private String promoter;

    @ApiModelProperty(value = "创建人ID")
    private String createUserId;

    @ApiModelProperty(value = "检验检测人员信息")
    List<TzsUserInfoVo> jyjcUserInfos;

    @ApiModelProperty(value = "检验检测区域负责人信息")
    List<TzsUserInfoVo> chargeUserInfos;


    @ApiModelProperty(value = "使用单位联系人")
    private String useContact;

    @ApiModelProperty(value = "联系人联系电话")
    private String contactPhone;

    @ApiModelProperty(value = "行业主管部门")
    private String industrySupervisor;

    @ApiModelProperty(value = "单位地理坐标经度")
    private String longitude;

    @ApiModelProperty(value = "单位地理坐标纬度")
    private String latitude;

    @ApiModelProperty(value = "单位地理坐标")
    private JyjcGeographicModel geographic;

    @ApiModelProperty("企业营业执照")
    private List<AttachmentDto> unitBusinessLicense;


    @ApiModelProperty("下个任务id")
    private String nextTaskId;

    @ApiModelProperty("下个任务执行人ids")
    private String nextExecuteUserIds;

    @ApiModelProperty("是否监管")
    private String identityType;

    @ApiModelProperty("转办人")
    private String transferToUserIds;

    @ApiModelProperty("对接单位code")
    private String dockingUnitCode;

    @ApiModelProperty("开通的业务类型")
    private String openBizType;

    @ApiModelProperty("开通的业务类型名称")
    private String openBizTypeName;

    @ApiModelProperty("机构分类")
    private String agencyClassify;

    @ApiModelProperty(value = "企业资质证书信息")
    List<BaseEnterpriseCertDto> baseUnitLicences;

    @ApiModelProperty(value = "省内办公地址")
    private String officeRegion;

    @ApiModelProperty(value = "省内详细办公地址")
    private String officeAddress;

    @ApiModelProperty(value = "单位所在地：陕西省内企业，省外企业")
    private String dataSources;

    @ApiModelProperty(value = "仪器设备台账及检定证书")
    private JSONArray equipVeriCert;

    @ApiModelProperty(value = "档案室(请上传符合要求的自我声明)")
    private JSONArray archivesCert;

    @ApiModelProperty(value = "仪器室(请上传符合要求的自我声明)")
    private JSONArray instrumentCert;

    @ApiModelProperty(value = "质量保证体系(请上传符合要求的自我声明)")
    private JSONArray quaSystemCert;

    @ApiModelProperty(value = "登录单位类型")
    private String companyLevel;

    @ApiModelProperty(value = "检测区域编码")
    private List<String> oriDetectionRegion;
}
