package com.yeejoin.amos.boot.module.jyjc.api.model;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.Date;

/**
 * @author Administrator
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class TaskModelDto {
        /**
         * 工作流创建时间
         */
        private Date flowCreateDate;
        /**
         * 工作流返回节点名称
         */
        private String taskName;
        /**
         * 任务编号 可以使用申请单编号
         */
        private String taskCode;
        /**
         * 流程任务ID
         */
        private String flowCode;
        /**
         * 统一定义的枚举code 例如  6612 待受理
         */
        private Integer flowStatus;
        /**
         * 统一定义的枚举code 例如  6612 待受理
         */
        private String flowStatusLabel;
        /**
         * 摘要-来源
         */
        private String taskContent;

        /**
         * 描述-非必输
         */
        private String taskDesc;
        /**
         * 任务类型   从BusinessTypeEnum中获取自己对应类型code
         **/
        private String taskType;
        /**
         * 任务类型名称 汉字   从BusinessTypeEnum中获取自己对应类型名称
         **/
        private String taskTypeLabel;
        /***
         * 关联id 传工作流实例id
         * */
        private String relationId;
        /**
         * 执行人id 从工作流中获取
         **/
        private String executeUserIds;
        /**
         * 任务状态  操作名称  0 待处理  1驳回 2通过 3重新提交
         */
        private Integer taskStatus;
        /**
         * 任务状态 操作名称  0 待处理  1驳回 2通过 3重新提交
         */
        private String taskStatusLabel;
        /**
         * 任务发起人id 不变  第一次提交的人
         * 从业务表中 created_uesr_id
         */
        private String startUserId;
        /**
         * 任务发起人名称 不变
         * 名字
         */
        private String startUser;
        /**
         * 任务发起人所在单位 不变
         */
        private String startUserCompanyName;
        /**
         * 任务发起人发起时间 不变
         */
        private Date startDate;
        /**
         * 跳转路径
         */
        private String routePath;
        /**
         * 当前业务实体对象
         */
        private Object model;
        /**
         * 下一节点执行角色
         */
        private String nextExecuteUser;
        /**
         * 是否跳转编辑页面
         * */
        private String pageType;
}

