package com.yeejoin.amos.boot.module.tdc.biz.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yeejoin.amos.boot.module.tdc.api.dto.CheckResultDto;
import com.yeejoin.amos.boot.module.tdc.api.entity.CheckModel;
import com.yeejoin.amos.boot.module.tdc.api.entity.CheckReport;
import com.yeejoin.amos.boot.module.tdc.api.entity.CheckResult;
import com.yeejoin.amos.boot.module.tdc.api.mapper.CheckResultMapper;
import com.yeejoin.amos.boot.module.tdc.api.service.CheckResultService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
public class CheckResultImpl extends ServiceImpl<CheckResultMapper, CheckResult> implements CheckResultService {

    @Autowired
    CheckResultMapper checkResultMapper;


    @Override
    public List<CheckResultDto> selectResult(String code) {
        return checkResultMapper.selectResult(code);
    }

    @Override
    public List<CheckResult> selectCheckResult(String modelId,String amosOrgCode) {
        LambdaQueryWrapper<CheckResult> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(CheckResult::getCheckItemResult, "1")
        .eq(CheckResult::getAmosOrgCode, amosOrgCode)
        .eq(CheckResult::getModelId, modelId);
        return baseMapper.selectList(wrapper);
    }

}
