package com.yeejoin.amos.boot.module.common.api.enums;

import lombok.Getter;

import java.util.*;

@Getter
public enum UserPostEnum {
    // type 1生产单位 2使用单位 3充装单位 4检验机构 5检测机构
    //主要负责人
    ZYFZR("主要负责人","6548","1,2,3"),
    //质量安全总监
    ZLAQZJ("质量安全总监","6550","1"),
    //质量安全员
    ZLAQY("质量安全员","6551","1"),
    //作业人员
    ZYRY("作业人员", "6552", "1,2,3"),
    //检验人员
    ZJRY("检验人员", "66151", "1,2,4,5"),
    //检测人员
    JCRY("检测人员", "66152", "1,2,4,5"),
    //安全总监
    AQZJ("安全总监","6547","2,3"),
    //安全员
    AQY("安全员","6549","2,3"),

    JSFZR("技术负责人", "6660", ""),

    SJRY("设计人员", "6661", ""),

    JSRY("技术人员", "6662", ""),

    ZLJYRY("质量检验人员", "6663", ""),

    XMFZR("项目负责人", "6664", ""),

    LHJYRY("理化检验人员", "6665", ""),

    HYRY("化验人员", "6666", ""),

    JYJCQYFZR("检验检测区域负责人", "6667", ""),

    AQGLY("安全管理员", "6617", ""),

    ZLFZR("质量负责人", "6761", ""),

    ZRS("责任师", "6762", ""),

    JCARY("检查人员", "6763", ""),

    FXBSY("风险报送员", "6766", ""),

    YWFZR("业务负责人", "6767", ""),

    PTYG("普通员工", "6546", ""),

    YWBLRY("业务办理人员", "6616", ""),

    AGWFZR("安改维负责人", "6553", ""),

    // 质量保证体系人员
    ZLBZTXRY("质量保证体系人员", "6619", "1");

    String name;
    String code;
    String type;

    private UserPostEnum(String name, String code, String type) {
        this.name = name;
        this.code = code;
        this.type = type;
    }

    public static List<Map<String,String>> getEnumListByType(String type) {
        List<Map<String,String>> list = new ArrayList<>();
        for (UserPostEnum testEnum : EnumSet.allOf(UserPostEnum.class)) {
            Map<String,String> map = new HashMap<>();
            if (null == type) {
                map.put("name", testEnum.getName());
                map.put("code", testEnum.getCode());
                list.add(map);
            } else {
                if (testEnum.getType().contains(type)) {
                    map.put("name", testEnum.getName());
                    map.put("code", testEnum.getCode());
                    list.add(map);
                }
            }
        }
        return list;
    }


}
