package com.yeejoin.amos.boot.module.cylinder.biz.controller;

import java.util.Date;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.yeejoin.amos.boot.module.cylinder.api.dto.TzsJgBasicOutterDto;
import com.yeejoin.amos.boot.module.cylinder.api.entity.PageParam;
import com.yeejoin.amos.boot.module.cylinder.api.service.ITzsJgOutterService;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

/**
 * 特种设备监管controller
 */
@RestController
@Api(tags = "特种设备监管对外Api")
@RequestMapping(value = "/tzs-jg-outter-api")
public class TzsJGOutterController {

	@Autowired
	ITzsJgOutterService iTzsJgOutterService;

	/**
	 * 查询监管设备列表
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = true)
	@GetMapping(value = "/page")
	@ApiOperation(httpMethod = "GET", value = "查询监管设备列表", notes = "查询监管设备列表")
	public ResponseModel<IPage<TzsJgBasicOutterDto>> page(PageParam pageParam,
			@DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss") Date startTime,
			@DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss") Date endTime) {
		return ResponseHelper.buildResponse(iTzsJgOutterService.page(pageParam, startTime, endTime));
	}

}
