package com.yeejoin.amos.boot.module.statistics.api.mapper;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.common.api.dto.DPFilterParamForDetailDto;
import com.yeejoin.amos.boot.module.statistics.api.dto.CylinderFillingMessageModel;
import com.yeejoin.amos.boot.module.ymt.api.dto.TzBaseEnterpriseInfoDto;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * Mapper 接口
 *
 * @author system_generator
 * @date 2023-12-13
 */
@Mapper
public interface CylinderStatisticsMapper {

    Long countEnterpriseNumForCylinder(@Param("orgCode") String orgCode);

    /**
     * 按照管辖维度，统计充装单位使用登记证的办理率
     * @param orgCode 区域对应的单位orgCode
     * @return 办理率*100
     */
    String queryUserRegisterCertAppPercent(@Param("orgCode") String orgCode);

    /**
     * 统计气瓶的办证数量
     * @param orgCode 区域对应的公司的orgCode
     * @return 办证数量
     */
    Long countForCylinderCertNum(String orgCode);

    Long countFillingVolumeCount(@Param("orgCode") String orgCode);

    Long countDischargeVolumeCount(@Param("orgCode") String orgCode);

    Long countEnterpriseUsed(@Param("orgCode") String orgCode);

    IPage<TzBaseEnterpriseInfoDto> getStationRateSubPage(IPage<TzBaseEnterpriseInfoDto> page,
                                                         @Param("companyName") String companyName,
                                                         @Param("orgCode") String orgCode);
    IPage<CylinderFillingMessageModel> getUploadCylinderLogsPage(IPage<CylinderFillingMessageModel> page,
                                                             @Param("orgCode") String orgCode);

    Long countFilling(@Param("orgCode") String orgCode, @Param("startTime") String startTime, @Param("endTime") String endTime);

    Long countOffloading(@Param("orgCode") String orgCode, @Param("startTime") String startTime, @Param("endTime") String endTime);

    Page<Map<String, Object>> getNormalPage(@Param("page") Page<Map<String, Object>> page, @Param("dpFilterParamForDetailDto") DPFilterParamForDetailDto dpFilterParamForDetailDto);
    List<Map<String, Object>> getNormalByUnitCode(@Param("unitCodeList") List<String> unitCodeList, @Param("dpFilterParamForDetailDto") DPFilterParamForDetailDto dpFilterParamForDetailDto);
}
