package com.yeejoin.amos.api.openapi.feign;


import com.baomidou.mybatisplus.core.metadata.IPage;
import com.yeejoin.amos.api.openapi.face.model.ElevatorModel;
import com.yeejoin.amos.boot.biz.common.feign.FeignConfiguration;
import com.yeejoin.amos.boot.module.cylinder.api.dto.PageParam;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.typroject.tyboot.core.restful.utils.ResponseModel;
import java.util.Date;
import java.util.List;
import java.util.Map;

@FeignClient(name = "TZS-JG", path = "/jg", configuration = {FeignConfiguration.class})
public interface TzsJgServiceFeignClient {

    /**
     * 根据企业统一信用代码询许可信息
     *
     * @param unitCode 企业唯一编码
     * @return
     */
    @RequestMapping(value = "/baseEnterprise/getUnitLicenceMessage", method = RequestMethod.GET)
    ResponseModel<Object> getLicenceByUnitCode(@RequestParam String unitCode);


    /**
     * 字段列表查询
     * @param dictCode 字段类型
     * @return 列表
     */
    @RequestMapping(value = "/getDataDictionary/{dictCode}", method = RequestMethod.GET)
    ResponseModel<Object> getDataDictionary(@PathVariable String dictCode);

    /**
     * 根据时间范围查询
     * @param equCode 设备代码
     * @param startTime 开始时间
     * @param endTime 结束时间
     * @return 电梯数据
     */
    @RequestMapping(value = "/equipment-register/getElevatorInfo", method = RequestMethod.GET)
    IPage<ElevatorModel> getElevatorInfo(@RequestParam("equCode") String equCode,
                                        @RequestParam("startTime") Date startTime,
                                        @RequestParam("startTime") Date endTime,
                                        PageParam pageParam);

    /**
     * 根据时间范围查询液化石油气瓶档案
     * @param equCode 设备代码
     * @param startTime 开始时间
     * @param endTime 结束时间
     * @return 电梯数据
     */
    @RequestMapping(value = "/equipment-register/getCylinderInfo", method = RequestMethod.GET)
    IPage<ElevatorModel> getCylinderInfo(@RequestParam("equCode") String equCode,
                                         @RequestParam("startTime") Date startTime,
                                         @RequestParam("startTime") Date endTime,
                                         PageParam pageParam);

    /**
     * 查询气站信息
     * @return
     */
    @RequestMapping(value = "/equipment-register/getCylinderStationInfo", method = RequestMethod.GET)
    List<Map<String, Object>> getCylinderStationInfo();

    @RequestMapping(value = "/equipment-register/getVehicleCylinderInfo", method = RequestMethod.GET)
    List<Map<String, Object>> getVehicleCylinderInfo(String useCode);
}
