package com.yeejoin.amos.boot.module.jg.api.service;


import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.bo.ReginParams;
import com.yeejoin.amos.boot.module.jg.api.dto.JgChangeRegistrationUnitDto;
import com.yeejoin.amos.boot.module.jg.api.entity.JgChangeRegistrationUnit;

import java.util.List;
import java.util.Map;

/**
 * 单位变更登记接口类
 *
 * @author system_generator
 * @date 2023-12-22
 */
public interface IJgChangeRegistrationUnitService {


    /**
     * 根据sequenceNbr查询
     *
     * @param sequenceNbr 主键
     * @return 安装告知
     */
    Map<String, Map<String, Object>> queryBySequenceNbr(Long sequenceNbr);

    /**
     * 更新安装告知
     *
     * @param noticeDto 安装告知
     * @param op        操作类型
     */
    JgChangeRegistrationUnitDto updateInstallationNotice(String submitType, JgChangeRegistrationUnitDto noticeDto, String op, ReginParams reginParams);

    /**
     * 分页查询
     *
     * @param page  分页对象
     * @param model 查询参数
     * @param type  类型：enterprise-企业端、supervision-监管端
     * @return 安装告知列表
     */
    Page<JgChangeRegistrationUnitDto> queryForJgChangeRegistrationUnitPage(Page<JgChangeRegistrationUnit> page,
                                                                           String sort,
                                                                           JgChangeRegistrationUnitDto model,
                                                                           String type,
                                                                           ReginParams reginParams);

    /**
     * 批量删除
     *
     * @param sequenceNbrs 主键
     * @return 是否删除成功
     */
    Boolean deleteForBatch(Long[] sequenceNbrs);

    /**
     * 保存安装告知单
     *
     * @param model      数据
     * @param submitType 保存类型
     */
    List<JgChangeRegistrationUnitDto> saveNotice(String submitType, JSONObject model, ReginParams reginParams);

}
