package com.yeejoin.amos.boot.module.statistcs.biz.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.common.api.dto.DPFilterParamDto;
import com.yeejoin.amos.boot.module.common.api.dto.DPFilterParamForDetailDto;
import com.yeejoin.amos.boot.module.jg.api.dto.FourColorCountDataDto;
import com.yeejoin.amos.boot.module.jg.api.dto.JgUseRegistrationManageDto;
import com.yeejoin.amos.boot.module.jg.api.dto.SafetyProblemTracingDto;
import com.yeejoin.amos.boot.module.statistcs.biz.service.impl.JGDPStatisticsServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.validation.BindingResult;
import org.springframework.validation.FieldError;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.exception.instance.BadRequest;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;
import java.util.List;
import java.util.Map;

/**
 * 大屏统计controller
 *
 * @author Administrator
 */
@RestController
@Api(tags = "大屏-监管及总览统计API")
@RequestMapping("/dp/jg")
public class JGDPStatisticsController {


    private JGDPStatisticsServiceImpl statisticsService;

    public JGDPStatisticsController(JGDPStatisticsServiceImpl statisticsService) {
        this.statisticsService = statisticsService;
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "POST", value = "大屏总览-右侧使用登记统计", notes = "大屏总览右侧-使用登记统计")
    @PostMapping(value = "/useRegister/count/byEquList")
    public ResponseModel<Map<String, Object>> useRegisterCountByEquList(@Validated @RequestBody DPFilterParamDto dpFilterParamDto, BindingResult result) {
        List<FieldError> fieldErrors = result.getFieldErrors();
        if (!fieldErrors.isEmpty()) {
            throw new BadRequest(fieldErrors.get(0).getDefaultMessage());
        }
        return ResponseHelper.buildResponse(statisticsService.useRegisterCountByEquList(dpFilterParamDto));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "POST", value = "大屏总览-中间地图左右两侧8大类、单位、人员数量全局统计", notes = "大屏总览中间-地图左右两侧8大类、单位、人员数量全局统计")
    @PostMapping(value = "/zl/center-map/legend")
    public ResponseModel<Map<String, Object>> centerMapCountForGlobal(@Validated @RequestBody DPFilterParamDto dpFilterParamDto, BindingResult result) {
        List<FieldError> fieldErrors = result.getFieldErrors();
        if (!fieldErrors.isEmpty()) {
            throw new BadRequest(fieldErrors.get(0).getDefaultMessage());
        }
        return ResponseHelper.buildResponse(statisticsService.getCenterMapCountDataForGlobal(dpFilterParamDto));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "POST", value = "大屏总览-中间地图地市统计", notes = "大屏总览中间-地图地市统计")
    @PostMapping(value = "/zl/center-map/overview")
    public ResponseModel<List<Map<String, Object>>> centerMapCountForOverview(@Validated @RequestBody DPFilterParamDto dpFilterParamDto, BindingResult result) {
        List<FieldError> fieldErrors = result.getFieldErrors();
        if (!fieldErrors.isEmpty()) {
            throw new BadRequest(fieldErrors.get(0).getDefaultMessage());
        }
        return ResponseHelper.buildResponse(statisticsService.getCenterMapCountDataForOverview(dpFilterParamDto));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "POST", value = "大屏8大类-左侧气瓶使用登记统计", notes = "大屏八大类左侧-使用登记统计")
    @PostMapping(value = "/useRegisterCount")
    public ResponseModel<Map<String, Object>> useRegisterCount(@Validated @RequestBody DPFilterParamDto dpFilterParamDto, BindingResult result) {
        List<FieldError> fieldErrors = result.getFieldErrors();
        if (!fieldErrors.isEmpty()) {
            throw new BadRequest(fieldErrors.get(0).getDefaultMessage());
        }
        return ResponseHelper.buildResponse(statisticsService.useRegisterCount(dpFilterParamDto));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "POST", value = "大屏总览-左侧-安全指数", notes = "大屏总览-一码知风险-安全指数")
    @PostMapping(value = "/zl/left/safetyIndex")
    public ResponseModel<Map<String, Object>> querySafetyIndex(@Validated @RequestBody DPFilterParamDto dpFilterParamDto, BindingResult result) {
        List<FieldError> fieldErrors = result.getFieldErrors();
        if (!fieldErrors.isEmpty()) {
            throw new BadRequest(fieldErrors.get(0).getDefaultMessage());
        }
        return ResponseHelper.buildResponse(statisticsService.querySafetyIndex(dpFilterParamDto));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "POST", value = "大屏总览-左侧-四色管安全", notes = "大屏总览-左侧-四色管安全")
    @PostMapping(value = "/zl/left/fourColorManager")
    public ResponseModel<List<FourColorCountDataDto>> fourColorManagerSafety(@Validated @RequestBody DPFilterParamDto dpFilterParamDto, BindingResult result) {
        List<FieldError> fieldErrors = result.getFieldErrors();
        if (!fieldErrors.isEmpty()) {
            throw new BadRequest(fieldErrors.get(0).getDefaultMessage());
        }
        return ResponseHelper.buildResponse(statisticsService.queryFourColorManagerSafetyData(dpFilterParamDto));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "POST", value = "大屏总览-右侧-业务全过程", notes = "大屏总览-右侧-业务全过程")
    @PostMapping(value = "/zl/right/bizCycle")
    public ResponseModel<Map<String, Object>> queryBizCycleData(@Validated @RequestBody DPFilterParamDto dpFilterParamDto, BindingResult result) {
        List<FieldError> fieldErrors = result.getFieldErrors();
        if (!fieldErrors.isEmpty()) {
            throw new BadRequest(fieldErrors.get(0).getDefaultMessage());
        }
        return ResponseHelper.buildResponse(statisticsService.queryBizCycleData(dpFilterParamDto));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "POST", value = "大屏总览-右侧-使用监管下钻", notes = "大屏总览-右侧-使用监管下钻")
    @PostMapping(value = "/zl/right/bizCycleDetail")
    public ResponseModel<Map<String, Object>> queryBizCycleDataDetail(@Validated @RequestBody DPFilterParamForDetailDto dpFilterParamForDetailDto, BindingResult result) {
        List<FieldError> fieldErrors = result.getFieldErrors();
        if (!fieldErrors.isEmpty()) {
            throw new BadRequest(fieldErrors.get(0).getDefaultMessage());
        }
        return ResponseHelper.buildResponse(statisticsService.queryBizCycleDataDetail(dpFilterParamForDetailDto));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "POST", value = "大屏总览-右侧-使用监管下钻列表", notes = "大屏总览-右侧-使用监管下钻列表")
    @PostMapping(value = "/zl/right/queryBizCycleDataDetailList")
    public ResponseModel<Page<Map<String, Object>>> queryBizCycleDataDetailList(@Validated @RequestBody DPFilterParamForDetailDto dpFilterParamForDetailDto, BindingResult result,
                                                                                @RequestParam(value = "current", defaultValue = "1") Integer current,
                                                                                @RequestParam(value = "size", defaultValue = "20") Integer size) {
        List<FieldError> fieldErrors = result.getFieldErrors();
        if (!fieldErrors.isEmpty()) {
            throw new BadRequest(fieldErrors.get(0).getDefaultMessage());
        }
        Page<Map<String, Object>> page = new Page<>(current,size);
        return ResponseHelper.buildResponse(statisticsService.queryBizCycleDataDetailList(dpFilterParamForDetailDto,page));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "POST", value = "大屏-监管-左侧设备状态情况统计", notes = "大屏-监管-左侧设备状态情况统计")
    @PostMapping(value = "/equStateCount")
    public ResponseModel<List<Map<String, Object>>> equStateCount(@Validated @RequestBody DPFilterParamDto dpFilterParamDto, BindingResult result) {
        List<FieldError> fieldErrors = result.getFieldErrors();
        if (!fieldErrors.isEmpty()) {
            throw new BadRequest(fieldErrors.get(0).getDefaultMessage());
        }
        return ResponseHelper.buildResponse(statisticsService.equStateCount(dpFilterParamDto));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "POST", value = "监管大屏-右侧停用、注销、报废设备状态情况统计", notes = "监管大屏-右侧停用、注销、报废设备状态情况统计")
    @PostMapping(value = "/equStopStateCount")
    public ResponseModel<Map<String, Object>> equStopStateCount(@Validated @RequestBody DPFilterParamDto dpFilterParamDto, BindingResult result) {
        List<FieldError> fieldErrors = result.getFieldErrors();
        if (!fieldErrors.isEmpty()) {
            throw new BadRequest(fieldErrors.get(0).getDefaultMessage());
        }
        return ResponseHelper.buildResponse(statisticsService.equStopStateCount(dpFilterParamDto));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "POST", value = "监管大屏-维保电梯数量TOP10", notes = "监管大屏-维保电梯数量TOP10")
    @PostMapping(value = "/maintenanceCountTopTen")
    public ResponseModel<List<Map<String, Object>>> maintenanceCountTopTen(@Validated @RequestBody DPFilterParamDto dpFilterParamDto, BindingResult result) {
        List<FieldError> fieldErrors = result.getFieldErrors();
        if (!fieldErrors.isEmpty()) {
            throw new BadRequest(fieldErrors.get(0).getDefaultMessage());
        }
        return ResponseHelper.buildResponse(statisticsService.maintenanceCountTopTen(dpFilterParamDto));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "POST", value = "监管大屏-维保电梯数量", notes = "监管大屏-维保电梯数量")
    @PostMapping(value = "/maintenanceCount")
    public ResponseModel<Map<String, Object>> maintenanceCount(@Validated @RequestBody DPFilterParamDto dpFilterParamDto, BindingResult result) {
        List<FieldError> fieldErrors = result.getFieldErrors();
        if (!fieldErrors.isEmpty()) {
            throw new BadRequest(fieldErrors.get(0).getDefaultMessage());
        }
        return ResponseHelper.buildResponse(statisticsService.maintenanceCount(dpFilterParamDto));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "POST", value = "监管大屏-左侧各地市业务办理平均时效", notes = "监管大屏-左侧各地市业务办理平均时效")
    @PostMapping(value = "/cityBusinessCount")
    public ResponseModel<Map<String, Object>> cityBusinessCount(@Validated @RequestBody DPFilterParamDto dpFilterParamDto, BindingResult result) {
        List<FieldError> fieldErrors = result.getFieldErrors();
        if (!fieldErrors.isEmpty()) {
            throw new BadRequest(fieldErrors.get(0).getDefaultMessage());
        }
        return ResponseHelper.buildResponse(statisticsService.cityBusinessCount(dpFilterParamDto));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "POST", value = "监管大屏-左侧获取业务类型", notes = "监管大屏-左侧获取业务类型")
    @PostMapping(value = "/getBusinessKey")
    public ResponseModel<List<Map<String, Object>>> getBusinessKey(@Validated @RequestBody DPFilterParamDto dpFilterParamDto, BindingResult result) {
        List<FieldError> fieldErrors = result.getFieldErrors();
        if (!fieldErrors.isEmpty()) {
            throw new BadRequest(fieldErrors.get(0).getDefaultMessage());
        }
        return ResponseHelper.buildResponse(statisticsService.getBusinessKey(dpFilterParamDto));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "POST", value = "监管大屏-右侧施工告知的设备数办理情况统计", notes = "监管大屏-右侧施工告知的设备数办理情况统计")
    @PostMapping(value = "/getNoticeEquCount")
    public ResponseModel<Map<String, Object>> getNoticeEquCount(@Validated @RequestBody DPFilterParamDto dpFilterParamDto, BindingResult result) {
        List<FieldError> fieldErrors = result.getFieldErrors();
        if (!fieldErrors.isEmpty()) {
            throw new BadRequest(fieldErrors.get(0).getDefaultMessage());
        }
        return ResponseHelper.buildResponse(statisticsService.getNoticeEquCount(dpFilterParamDto));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "POST", value = "监管大屏-右侧使用办理的设备数量情况统计", notes = "监管大屏-右侧使用办理的设备数量情况统计")
    @PostMapping(value = "/getRegEquCount")
    public ResponseModel<Map<String, Object>> getRegEquCount(@Validated @RequestBody DPFilterParamDto dpFilterParamDto, BindingResult result) {
        List<FieldError> fieldErrors = result.getFieldErrors();
        if (!fieldErrors.isEmpty()) {
            throw new BadRequest(fieldErrors.get(0).getDefaultMessage());
        }
        return ResponseHelper.buildResponse(statisticsService.getRegEquCount(dpFilterParamDto));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "POST", value = "监管大屏-左侧新增情况", notes = "监管大屏-左侧新增情况")
    @PostMapping(value = "/newRegEquCount")
    public ResponseModel<Map<String, Object>> newRegEquCount(@Validated @RequestBody DPFilterParamDto dpFilterParamDto, BindingResult result) {
        List<FieldError> fieldErrors = result.getFieldErrors();
        if (!fieldErrors.isEmpty()) {
            throw new BadRequest(fieldErrors.get(0).getDefaultMessage());
        }
        return ResponseHelper.buildResponse(statisticsService.newRegEquCount(dpFilterParamDto));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "POST", value = "监管大屏-新增登记新增设备统计", notes = "监管大屏-新增登记新增设备统计")
    @PostMapping(value = "/newRegCount")
    public ResponseModel<List<Map<String, Object>>> newRegCount(@Validated @RequestBody DPFilterParamDto dpFilterParamDto, BindingResult result) {
        List<FieldError> fieldErrors = result.getFieldErrors();
        if (!fieldErrors.isEmpty()) {
            throw new BadRequest(fieldErrors.get(0).getDefaultMessage());
        }
        return ResponseHelper.buildResponse(statisticsService.newRegCount(dpFilterParamDto));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "POST", value = "大屏监管-中屏-各地市数据统计", notes = "大屏监管-中屏-各地市数据统计")
    @PostMapping(value = "/centre/dataStatisticOld")
    public ResponseModel<List<Map<String, Object>>> dataStatisticByReginCode(@Validated @RequestBody DPFilterParamDto dpFilterParamDto, BindingResult result) {
        List<FieldError> fieldErrors = result.getFieldErrors();
        if (!fieldErrors.isEmpty()) {
            throw new BadRequest(fieldErrors.get(0).getDefaultMessage());
        }
        return ResponseHelper.buildResponse(statisticsService.dataStatisticByReginCode(dpFilterParamDto));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "POST", value = "大屏监管-中屏-当前区域数据统计", notes = "大屏监管-中屏-当前区域数据统计")
    @PostMapping(value = "/centre/dataStatisticCountOld")
    public ResponseModel<Map<String, Object>> dataStatisticCountByReginCode(@Validated @RequestBody DPFilterParamDto dpFilterParamDto, BindingResult result) {
        List<FieldError> fieldErrors = result.getFieldErrors();
        if (!fieldErrors.isEmpty()) {
            throw new BadRequest(fieldErrors.get(0).getDefaultMessage());
        }
        return ResponseHelper.buildResponse(statisticsService.dataStatisticCountByReginCode(dpFilterParamDto));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "POST", value = "监管大屏-中间地图左右两侧8大类、单位、人员数量全局统计", notes = "大屏总览中间-地图左右两侧8大类、单位、人员数量全局统计")
    @PostMapping(value = "/centre/dataStatistic")
    public ResponseModel<Map<String, Object>> JGCenterMapCountForGlobal(@Validated @RequestBody DPFilterParamDto dpFilterParamDto, BindingResult result) {
        List<FieldError> fieldErrors = result.getFieldErrors();
        if (!fieldErrors.isEmpty()) {
            throw new BadRequest(fieldErrors.get(0).getDefaultMessage());
        }
        return ResponseHelper.buildResponse(statisticsService.JGCenterMapCountForGlobal(dpFilterParamDto));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "POST", value = "监管大屏-中间地图地市统计", notes = "大屏总览中间-地图地市统计")
    @PostMapping(value = "/centre/dataStatisticCount")
    public ResponseModel<List<Map<String, Object>>> JGCenterMapCountForOverview(@Validated @RequestBody DPFilterParamDto dpFilterParamDto, BindingResult result) {
        List<FieldError> fieldErrors = result.getFieldErrors();
        if (!fieldErrors.isEmpty()) {
            throw new BadRequest(fieldErrors.get(0).getDefaultMessage());
        }
        return ResponseHelper.buildResponse(statisticsService.JGCenterMapCountForOverview(dpFilterParamDto));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "POST", value = "监管大屏-右屏-施工情况列表（近30天）", notes = "监管大屏-右屏-施工情况列表（近30天）")
    @PostMapping(value = "/noticeList")
    public ResponseModel<List<Map<String, Object>>> noticeList(@Validated @RequestBody DPFilterParamDto dpFilterParamDto, BindingResult result) {
        List<FieldError> fieldErrors = result.getFieldErrors();
        if (!fieldErrors.isEmpty()) {
            throw new BadRequest(fieldErrors.get(0).getDefaultMessage());
        }
        return ResponseHelper.buildResponse(statisticsService.noticeList(dpFilterParamDto));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "POST", value = "监管大屏-右屏-施工情况列表（近30天）下钻列表", notes = "监管大屏-右屏-施工情况列表（近30天）下钻列表")
    @PostMapping(value = "/noticeDetailList")
    public ResponseModel<Page<Map<String, Object>>> noticeDetailList(@Validated @RequestBody DPFilterParamForDetailDto dpFilterParamDto, BindingResult result,
                                                                     @RequestParam(value = "current", defaultValue = "1") Integer current,
                                                                     @RequestParam(value = "size", defaultValue = "20") Integer size) {
        List<FieldError> fieldErrors = result.getFieldErrors();
        if (!fieldErrors.isEmpty()) {
            throw new BadRequest(fieldErrors.get(0).getDefaultMessage());
        }
        Page<Map<String, Object>> page = new Page<>(current, size);
        return ResponseHelper.buildResponse(statisticsService.noticeDetailList(page,dpFilterParamDto));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "POST", value = "监管大屏-右屏-施工情况列表（近30天）下钻类型接口", notes = "监管大屏-右屏-施工情况列表（近30天）下钻类型接口")
    @PostMapping(value = "/noticeListBusinessType")
    public ResponseModel<List<Map<String, Object>>> noticeListBusinessType(@Validated @RequestBody DPFilterParamForDetailDto dpFilterParamDto, BindingResult result) {
        List<FieldError> fieldErrors = result.getFieldErrors();
        if (!fieldErrors.isEmpty()) {
            throw new BadRequest(fieldErrors.get(0).getDefaultMessage());
        }
        return ResponseHelper.buildResponse(statisticsService.noticeListBusinessType(dpFilterParamDto));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "POST", value = "监管大屏-右屏-施工单位施工总量排名TOP10", notes = "大屏总览-右屏-施工单位施工总量排名TOP10")
    @PostMapping(value = "/noticeCountTop")
    public ResponseModel<List<Map<String, Object>>> noticeCountTop(@Validated @RequestBody DPFilterParamDto dpFilterParamDto, BindingResult result) {
        List<FieldError> fieldErrors = result.getFieldErrors();
        if (!fieldErrors.isEmpty()) {
            throw new BadRequest(fieldErrors.get(0).getDefaultMessage());
        }
        return ResponseHelper.buildResponse(statisticsService.noticeCountTop(dpFilterParamDto));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "POST", value = "监管大屏-右屏-近30天办结率下钻类型", notes = "监管大屏-右屏-近30天办结率下钻类型")
    @PostMapping(value = "/getBusinessType")
    public ResponseModel<List<Map<String, Object>>> getBusinessType(@Validated @RequestBody DPFilterParamForDetailDto dpFilterParamForDetailDto, BindingResult result) {
        List<FieldError> fieldErrors = result.getFieldErrors();
        if (!fieldErrors.isEmpty()) {
            throw new BadRequest(fieldErrors.get(0).getDefaultMessage());
        }
        return ResponseHelper.buildResponse(statisticsService.getBusinessType(dpFilterParamForDetailDto));
    }

    /**
     * 查询设备注册列表
     *
     * @param map
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/equipment-register/page")
    @ApiOperation(httpMethod = "GET", value = "设备注册信息分页查询", notes = "设备注册信息分页查询")
    public ResponseModel<Page<JSONObject>> queryForPage(@RequestParam Map<String, Object> map) {
        JSONObject jsonObject = new JSONObject(map);
        return ResponseHelper.buildResponse(statisticsService.queryForEquipmentRegisterPage(jsonObject));
    }

    /**
     * 查询设备注册信息详情
     *
     * @param record
     * @return 返回由页签的key包裹详情对象
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/equipment-register/{record}")
    @ApiOperation(httpMethod = "GET", value = "根据record查询设备注册信息详情", notes = "根据record查询设备注册信息详情")
    public ResponseModel<Object> selectOne(@PathVariable String record, @RequestParam(required = false) String isCopy) {
        return ResponseHelper.buildResponse(statisticsService.getEquipmentRegisterByRecord(record, isCopy));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "common/equOnJgServiceOperationRecords")
    @ApiOperation(httpMethod = "GET", value = "查询设备在jg业务中的记录", notes = "查询设备在jg业务中的记录")
    public ResponseModel<List<Map<String, String>>> equOnJgServiceOperationRecords(@RequestParam(value = "record") String record) {
        return ResponseHelper.buildResponse(statisticsService.equOnJgServiceOperationRecords(record));
    }

    /**
     * 设备问题列表分页查询
     *
     * @param current 当前页
     * @param size 每页大小
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/safety-problem-tracing/equipId/page")
    @ApiOperation(httpMethod = "GET",value = "设备问题列表分页查询",  notes = "设备问题列表分页查询")
    public ResponseModel<Page<SafetyProblemTracingDto>> queryProblemPageByEquipId(@RequestParam(value = "current") int current, @RequestParam
            (value = "size") int size, @RequestParam(value = "record") String equipId) {
        Page<SafetyProblemTracingDto> page = new Page<>();
        page.setCurrent(current);
        page.setSize(size);
        return ResponseHelper.buildResponse(statisticsService.queryProblemPageByEquipId(page, equipId));
    }


    /**
     * 根据sequenceNbr查询
     *
     * @param sequenceNbr  主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/safety-problem-tracing/{sequenceNbr}")
    @ApiOperation(httpMethod = "GET",value = "根据sequenceNbr查询单个安全追溯问题",  notes = "根据sequenceNbr查询单个安全追溯问题")
    public ResponseModel<SafetyProblemTracingDto> selectSafetyProblem(@PathVariable Long sequenceNbr) {
        return ResponseHelper.buildResponse(statisticsService.selectSafetyProblem(sequenceNbr));
    }

    /**
     * 根据问题ID及问题类型查询关联设备列表
     *
     * @param problemId 问题Id
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET",value = "根据问题ID及问题类型查询关联设备列表",   notes = "根据问题ID及问题类型查询关联设备列表")
    @GetMapping(value = "/safety-problem-tracing/equip/list")
    public ResponseModel<Page<Map<String, Object>>> queryEquipListProblemById(@RequestParam(value = "current") int current,@RequestParam
            (value = "size") int size, @RequestParam(value = "sequenceNbr") String problemId) {
        Page<Map<String, Object>> page = new Page<>();
        page.setCurrent(current);
        page.setSize(size);
        return ResponseHelper.buildResponse(statisticsService.queryEquipListByProblemId(page, problemId));
    }

    /**
     * 根据问题ID及问题类型查询关联企业
     *
     * @param problemId 问题Id
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET",value = "根据问题ID及问题类型查询关联企业",   notes = "根据问题ID及问题类型查询关联企业")
    @GetMapping(value = "/safety-problem-tracing/unit/list")
    public ResponseModel<Page<Map<String, Object>>> queryPrincipalUnitByProblemId(@RequestParam(value = "current") int current,@RequestParam
            (value = "size") int size, @RequestParam(value = "sequenceNbr") String problemId) {
        Page<Map<String, Object>> page = new Page<>();
        page.setCurrent(current);
        page.setSize(size);
        return ResponseHelper.buildResponse(statisticsService.queryPrincipalUnitByProblemId(page, problemId));
    }

    /**
     * 根据sequenceNbr查询---大屏使用
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/jg-use-registration-manage/detail/dp")
    @ApiOperation(httpMethod = "GET", value = "根据sequenceNbr查询---大屏使用", notes = "根据sequenceNbr查询---大屏使用")
    public ResponseModel<Object> getRegistrationDetail(@RequestParam(value = "sequenceNbr") String sequenceNbr) {
        return ResponseHelper.buildResponse(statisticsService.getRegistrationDetail(sequenceNbr));
    }

    /**
     * 根据sequenceNbr查询使用登记证对应设备列表---使用登记证详情用
     * 分页接口
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/jg-use-registration-manage/detail/equList")
    @ApiOperation(httpMethod = "GET", value = "根据sequenceNbr查询使用登记证对应设备列表---使用登记证详情用", notes = "根据sequenceNbr查询使用登记证对应设备列表---使用登记证详情用")
    public ResponseModel<Page<JSONObject>> certificateEquList(@RequestParam(value = "current") int current,
                                                              @RequestParam(value = "size") int size,
                                                              @RequestParam(value = "sequenceNbr") String sequenceNbr) {
        return ResponseHelper.buildResponse(statisticsService.certificateEquList(current, size, sequenceNbr));
    }

    /**
     * 列表分页查询-大屏使用
     *
     * @param current 当前页
     * @param current 每页大小
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/safety-problem-tracing/page/dp")
    @ApiOperation(httpMethod = "POST",value = "分页查询安全追溯问题-大屏使用",  notes = "分页查询安全追溯问题-大屏使用")
    public ResponseModel<Page<SafetyProblemTracingDto>> getProblemRecords(@RequestParam(value = "current") int current,
                                                                          @RequestParam(value = "size") int size,
                                                                          @RequestBody(required = false) SafetyProblemTracingDto problemModel) {
        Page<SafetyProblemTracingDto> page = new Page<>();
        page.setCurrent(current);
        page.setSize(size);
        return ResponseHelper.buildResponse(statisticsService.getProblemRecords(page, problemModel));
    }

    /**
     * 列表分页查询-大屏监督管理使用
     *
     * @param current 当前页
     * @param current 每页大小
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/jg-use-registration-manage/page/dp")
    @ApiOperation(httpMethod = "GET", value = "分页查询", notes = "分页查询")
    public ResponseModel<Page<JgUseRegistrationManageDto>> getRecords(JgUseRegistrationManageDto dto,
                                                                      @RequestParam(value = "cityCode") String cityCode,
                                                                      @RequestParam(value = "current") int current,
                                                                      @RequestParam(value = "size") int size) {
        Page<JgUseRegistrationManageDto> page = new Page<JgUseRegistrationManageDto>();
        page.setCurrent(current);
        page.setSize(size);
        return ResponseHelper.buildResponse(statisticsService.getRegistrationRecords(page, dto, cityCode));
    }

}
