package com.yeejoin.amos.boot.module.statistcs.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.bo.ReginParams;
import com.yeejoin.amos.boot.biz.common.utils.RedisKey;
import com.yeejoin.amos.boot.biz.common.utils.RedisUtils;
import com.yeejoin.amos.boot.module.statistics.api.mapper.EnterpriseBizMapper;
import com.yeejoin.amos.boot.module.ymt.api.dto.TzBaseEnterpriseInfoDto;
import com.yeejoin.amos.boot.module.ymt.api.entity.PageParam;
import com.yeejoin.amos.boot.module.ymt.api.mapper.TzBaseEnterpriseInfoMapper;
import com.yeejoin.amos.component.feign.model.FeignClientResult;
import com.yeejoin.amos.feign.privilege.Privilege;
import com.yeejoin.amos.feign.privilege.model.CompanyModel;
import org.springframework.stereotype.Service;
import org.typroject.tyboot.core.foundation.context.RequestContext;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;

import java.util.ArrayList;
import java.util.List;

/**
 * @author Administrator
 */
@Service
public class EnterpriseBizServiceImpl {

    private RedisUtils redisUtils;

    private StCommonServiceImpl stCommonService;

    private TzBaseEnterpriseInfoMapper tzBaseEnterpriseInfoMapper;

    private EnterpriseBizMapper enterpriseBizMapper;

    public EnterpriseBizServiceImpl(RedisUtils redisUtils, StCommonServiceImpl stCommonService,
                                    TzBaseEnterpriseInfoMapper tzBaseEnterpriseInfoMapper,
                                    EnterpriseBizMapper enterpriseBizMapper) {
        this.redisUtils = redisUtils;
        this.stCommonService = stCommonService;
        this.tzBaseEnterpriseInfoMapper = tzBaseEnterpriseInfoMapper;
        this.enterpriseBizMapper = enterpriseBizMapper;
    }

    public IPage<TzBaseEnterpriseInfoDto> page(PageParam pageParam, TzBaseEnterpriseInfoDto tzBaseEnterpriseInfoDto) {
        List<String> orgCodeList = new ArrayList<>();
        if (tzBaseEnterpriseInfoDto.getSuperviseKey() != null) {
            FeignClientResult<CompanyModel> result = Privilege.companyClient
                    .seleteOne(Long.valueOf(tzBaseEnterpriseInfoDto.getSuperviseKey()));
            if (result.getResult() != null) {
                tzBaseEnterpriseInfoDto.setSuperviseOrgCode(result.getResult().getOrgCode());
            }
        }
        Page<TzBaseEnterpriseInfoDto> page = new Page<>(pageParam.getCurrent(), pageParam.getSize());
        List<JSONObject> companyType1 = this.getCompanyType();
        if (!ValidationUtil.isEmpty(companyType1)) {
            for (JSONObject jsonObject : companyType1) {
                String orgCode = jsonObject.getString("orgCode");
                if (!ValidationUtil.isEmpty(orgCode)) {
                    orgCodeList.add(orgCode);
                }
            }
        }
        if (tzBaseEnterpriseInfoDto.getCityCode() != null) {
            String orgCode = stCommonService.getAndSetOrgCode(tzBaseEnterpriseInfoDto.getCityCode());
            if (orgCode == null) {
                return page;
            }
            orgCodeList.add(orgCode);
        }
        return tzBaseEnterpriseInfoMapper.pageList2(page, tzBaseEnterpriseInfoDto, orgCodeList);
    }

    /**
     * 获取当前登录人单位类型
     *
     * @return
     */

    public List<JSONObject> getCompanyType() {


        ReginParams reginParams = JSON.parseObject(redisUtils.get(RedisKey.buildReginKey(RequestContext.getExeUserId(), RequestContext.getToken())).toString(), ReginParams.class);
        List<CompanyModel> companys = reginParams.getUserModel().getCompanys();

        List<JSONObject> objectList = new ArrayList<>();
        for (CompanyModel company : companys) {
            JSONObject object = new JSONObject();
            object.put("level", company.getLevel());
            object.put("orgCode", company.getOrgCode());
            object.put("companyCode", company.getCompanyCode());
            objectList.add(object);
        }
        return objectList;
    }
}
