package com.yeejoin.equipmanage.common.entity;

import java.util.Date;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.amos.boot.biz.common.annotation.FillCommonUserField;
import com.yeejoin.equipmanage.common.entity.publics.BaseEntity;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * @author keyong
 * @title: EquipmentSpecificAlarm
 * <pre>
 * @description: 设备报警信息
 * </pre>
 * @date 2020/10/30 18:22
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("wl_equipment_specific_alarm")
@FillCommonUserField(isAutoFill = false)
@ApiModel(value = "EquipmentSpecificAlarm设备报警信息", description = "设备报警信息")
public class EquipmentSpecificAlarm extends BaseEntity {

    @ApiModelProperty(value = "机构code")
    @TableField("org_code")
    private String orgCode;

    @ApiModelProperty(value = "装备名称")
    @TableField("equipment_specific_name")
    private String equipmentSpecificName;

    @ApiModelProperty(value = "消防设备id")
    @TableField("equipment_specific_id")
    private Long equipmentSpecificId;

    @ApiModelProperty(value = "iot编码")
    @TableField("iot_code")
    private String iotCode;

    @ApiModelProperty(value = "指标名称")
    @TableField("equipment_specific_index_name")
    private String equipmentSpecificIndexName;

    @ApiModelProperty(value = "指标编码")
    @TableField("equipment_specific_index_key")
    private String equipmentSpecificIndexKey;

    @ApiModelProperty(value = "报警值")
    @TableField("equipment_specific_index_value")
    private String equipmentSpecificIndexValue;

    @ApiModelProperty(value = "报警值说明")
    @TableField("equipment_specific_index_label")
    private String equipmentSpecificIndexLabel;

    @ApiModelProperty(value = "发生频次")
    @TableField("frequency")
    private int frequency;

    @ApiModelProperty(value = "报警状态：1报警0恢复    ->   1-报警  0-正常")
    @TableField("status")
    private int status;

    @ApiModelProperty(value = "报警类型:alarm_type_fire（火灾报警）/alarm_type_trouble（故障告警）")
    @TableField("type")
    private String type;

    @ApiModelProperty(value = "更新时间")
    @TableField("update_date")
    private Date updateDate;

    @ApiModelProperty(value = "告警恢复时间")
    @TableField("recovery_date")
    private Date recoveryDate;

    @ApiModelProperty(value = "指标id")
    @TableField("equipment_index_id")
    private Long equipmentIndexId;

    @ApiModelProperty(value = "确认类型")
    @TableField("confirm_type")
    private String confirmType;

    @ApiModelProperty(value = "报警原因")
    @TableField("alam_reason")
    private String alamReason;

    @ApiModelProperty(value = "处理情况")
    @TableField("resolve_result")
    private String resolveResult;

    @ApiModelProperty(value = "确警人员")
    @TableField("confirm_user")
    private String confirmUser;

    @ApiModelProperty(value = "确警人员姓名")
    private String confirmUserName;

    @ApiModelProperty(value = "确警时间")
    @TableField("confirm_date")
    private Date confirmDate;

    @ApiModelProperty(value = "iot数据上报唯一id")
    private String traceId;

    @ApiModelProperty(value = "画布id")
    @TableField(exist = false)
    private Long sceneId;

    @ApiModelProperty(value = "告警内容")
    @TableField(exist = false)
    private String alamContent;

    @ApiModelProperty(value = "告警部位")
    @TableField(exist = false)
    private String alamPlace;

    @ApiModelProperty(value = "告警设备名称")
    @TableField(exist = false)
    private String equipmentName;

    @ApiModelProperty(value = "保护对象")
    @TableField(exist = false)
    private String protectName;

    @ApiModelProperty(value = "是否已处理")
    @TableField(exist = false)
    private String isConfirm;

    @ApiModelProperty(value = "是否批量")
    @TableField(exist = false)
    private int isBatch;

    @ApiModelProperty(value = "报警类型")
    @TableField(exist = false)
    private String alarmCode;

    @ApiModelProperty(value = "设备二维码")
    @TableField(exist = false)
    private String qrCode;

    @ApiModelProperty(value = "设备编码")
    @TableField(exist = false)
    private String equipmentSpecificCode;

    @ApiModelProperty(value = "消防系统名称",notes = "告警详情时使用")
    @TableField(exist = false)
    private String systemName;

    @TableField("system_ids")
    @ApiModelProperty(value = "装备所属消防系统（冗余字段）")
    private String systemIds;

    @TableField("system_codes")
    @ApiModelProperty(value = "装备所属消防系统code（冗余字段）")
    private String systemCodes;

    @TableField("equipment_code")
    @ApiModelProperty(value = "装备定义code（冗余字段）")
    private String equipmentCode;

    @TableField("equipment_id")
    @ApiModelProperty(value = "装备定义id（冗余字段）")
    private Long equipmentId;

    @TableField("equipment_detail_id")
    @ApiModelProperty(value = "装备明细表id(冗余字段)")
    private Long equipmentDetailId;

    @TableField("location")
    @ApiModelProperty(value = "设备位置")
    private String location;

    @ApiModelProperty(value = "建筑id")
    @TableField(exist = false)
    private String buildId;

    /**
     * 颜色
     */
    @TableField(value = "emergency_level_color")
    private String emergencyLevelColor;

    /**
     * 紧急程度枚举（1：紧急，2：严重，3：轻微，4：正常，5：无效，6：备用，7：其他）
     */
    @TableField(value = "emergency_level")
    private String emergencyLevel;

    /**
     * 紧急程度描述
     */
    @TableField(value = "emergency_level_describe")
    private String emergencyLevelDescribe;

}
