package com.yeejoin.amos.boot.module.common.biz.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.yeejoin.amos.boot.module.common.api.entity.Firefighters;
import com.yeejoin.amos.boot.module.common.api.entity.OrgUsr;
import com.yeejoin.amos.boot.module.common.api.entity.OrgUsrAgencyUser;
import com.yeejoin.amos.boot.module.common.api.mapper.FirefightersMapper;
import com.yeejoin.amos.boot.module.common.api.mapper.OrgUsrAgencyUserMapper;
import com.yeejoin.amos.boot.module.common.api.mapper.OrgUsrMapper;
import com.yeejoin.amos.boot.module.common.api.service.IOrgUsrAgencyUserService;
import com.yeejoin.amos.boot.module.common.api.dto.OrgUsrAgencyUserDto;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.ObjectUtils;
import org.typroject.tyboot.core.rdbms.service.BaseService;
import org.springframework.stereotype.Service;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;

import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 单位人员平台人员关系表服务实现类
 *
 * @author system_generator
 * @date 2022-09-13
 */
@Service
public class OrgUsrAgencyUserServiceImpl extends BaseService<OrgUsrAgencyUserDto, OrgUsrAgencyUser, OrgUsrAgencyUserMapper> implements IOrgUsrAgencyUserService {

    @Autowired
    OrgUsrAgencyUserMapper orgUsrAgencyUserMapper;
    @Autowired
    FirefightersMapper firefightersMapper;
    @Autowired
    OrgUsrMapper orgUsrMapper;

    @Override
    public OrgUsrAgencyUser getAccountDetail(String orgUsrId) {
        return this.getOne(new LambdaQueryWrapper<OrgUsrAgencyUser>().eq(OrgUsrAgencyUser::getOrgUsrId, orgUsrId));
    }

    @Override
    public void synOrgUser(JSONObject jsonObject) {
        JSONObject result = jsonObject.getJSONObject("result");
        String methodName = jsonObject.getString("methodName");
        String userId = jsonObject.getString("userId");
        // 平台添加用户
        if ("update".equals(methodName)) {
            // 更新cb_org_usr_agency_user
            JSONObject object = result.getJSONObject("result");
            OrgUsrAgencyUser orgUsrAgencyUser = orgUsrAgencyUserMapper.selectOne(new QueryWrapper<OrgUsrAgencyUser>().eq("amos_user_id", object.getString("userId")));
            orgUsrAgencyUser.setUsrName(object.getString("userName"));
            orgUsrAgencyUser.setMobile(object.getString("mobile"));
            orgUsrAgencyUser.setAmosUserId(object.getString("userId"));
            orgUsrAgencyUserMapper.update(orgUsrAgencyUser,new QueryWrapper<OrgUsrAgencyUser>().eq("amos_user_id",object.getString("userId")));
            // 更新cb_firefighters
            Firefighters firefighter = firefightersMapper.selectOne(new QueryWrapper<Firefighters>().eq("org_usr_id", orgUsrAgencyUser.getOrgUsrId()));
            if (!ObjectUtils.isEmpty(firefighter) && !firefighter.getIsDelete()) {
                firefighter.setAmosUserId(object.get("userId").toString());
                firefighter.setAmosName(object.getString("userName"));
                firefightersMapper.update(firefighter, new QueryWrapper<Firefighters>().eq("org_usr_id", orgUsrAgencyUser.getOrgUsrId()));
            }
            // 更新cb_org_usr
            OrgUsr orgUsr1 = orgUsrMapper.selectById(orgUsrAgencyUser.getOrgUsrId());
            if (!ObjectUtils.isEmpty(orgUsr1) && !orgUsr1.getIsDelete()) {
                orgUsr1.setAmosOrgId(object.get("userId").toString());
                List<Map<String, Object>> companys = (List<Map<String, Object>>) object.get("companys");
                orgUsr1.setAmosOrgCode(companys.get(0).get("orgCode").toString());
                orgUsrMapper.update(orgUsr1,new QueryWrapper<OrgUsr>().eq("sequence_nbr",orgUsrAgencyUser.getOrgUsrId()));
            }
        } else if ("multDeleteUser".equals(methodName)) {
            JSONArray array = result.getJSONArray("result");
            List<Object> userIds = array.stream().collect(Collectors.toList());
            for (Object id : userIds) {
                //删除cb_org_usr_agency_user中信息
                OrgUsrAgencyUser orgUsrAgencyUser = orgUsrAgencyUserMapper.selectOne(new QueryWrapper<OrgUsrAgencyUser>().eq("amos_user_id", id));
                if (!ObjectUtils.isEmpty(orgUsrAgencyUser)) {
                    orgUsrAgencyUserMapper.delete(new QueryWrapper<OrgUsrAgencyUser>().eq("amos_user_id", id));
                }
                // 删除cb_firefighters和用户有关字段
                Firefighters firefighter = firefightersMapper.selectOne(new QueryWrapper<Firefighters>().eq("amos_user_id", id));
                if (!ObjectUtils.isEmpty(firefighter)) {
                    firefighter.setAmosUserId("");
                    firefighter.setAmosName("");
                    firefightersMapper.update(firefighter, new QueryWrapper<Firefighters>().eq("amos_user_id", id).eq("is_delete", 0));
                }
                // 删除cb_org_usr与用户有关字段
                OrgUsr orgUsr1 = orgUsrMapper.selectOne(new QueryWrapper<OrgUsr>().eq("amos_org_id", id));
                if (!ObjectUtils.isEmpty(orgUsr1)) {
                    orgUsr1.setAmosOrgId("");
                    orgUsr1.setAmosOrgCode("");
                    orgUsrMapper.update(orgUsr1,new QueryWrapper<OrgUsr>().eq("amos_org_id",id).eq("is_delete",0));
                }
            }
        }
    }
}