package com.yeejoin.amos.boot.module.jxiop.api.Enum;


import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.Getter;

@Getter
@AllArgsConstructor
public enum ElectricQuantity {
    ZXYGZ("正向总有功","zxzyg"),
    FXYGZ("反向总有功","fxzyg"),
    ZXWGZ("正向总无功","zxzwg"),
    FXWGZ("反向总无功","fxzwg"),
    ZGXWG("总感性无功","zgxwg"),
    ZZXYG("总正向有功","zzxwg"),
    ZRXWG("总容性无功","zrxwg"),
    ZFXYG("总反向有功","zfxyg");



    private String name;
    private String code;

    public static String getCode(String name) {

        for (ElectricQuantity electricQuantity : ElectricQuantity.values())
        {
            if (electricQuantity.getName().equals(name))
            {
                return electricQuantity.getCode();
            }
        }
        return null;
    }

}
