package com.yeejoin.equipmanage.common.interceptor;


import org.apache.ibatis.cache.CacheKey;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.plugin.*;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.springframework.stereotype.Component;
import org.springframework.util.ReflectionUtils;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Properties;

@Component
//	标志该类是一个拦截器
// {@Signature(type = StatementHandler.class, method = "prepare", args = {Connection.class, Integer.class})}
@Intercepts({
        @Signature(type = Executor.class, method = "query", args = {MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class}),
        @Signature(type = Executor.class, method = "query", args = {MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class, CacheKey.class, BoundSql.class}),
}
)
public class PluginInterceptor implements Interceptor {

    /**
     * 进行拦截的时候要执行的方法
     *
     * @param invocation
     * @return
     * @throws Throwable
     */
    public Object intercept(Invocation invocation) throws Throwable {
        Object[] args = invocation.getArgs();
        MappedStatement mappedStatement = (MappedStatement) args[0];
        Object parameter = args[1];
        RowBounds rowBounds = (RowBounds) args[2];
        ResultHandler resultHandler = (ResultHandler) args[3];
        Executor executor = (Executor) invocation.getTarget();
        CacheKey cacheKey;
        BoundSql boundSql;

        //由于逻辑关系，只会进入一次
        if (args.length == 4) {
            //4 个参数时
            boundSql = mappedStatement.getBoundSql(parameter);
            cacheKey = executor.createCacheKey(mappedStatement, parameter, rowBounds, boundSql);
        } else {
            //6 个参数时
            cacheKey = (CacheKey) args[4];
            boundSql = (BoundSql) args[5];
        }
        //id为执行的mapper方法的全路径名，如com.metro.dao.UserMapper.insertUser
        String id = mappedStatement.getId();

        //获取到原始sql语句
        String sql = boundSql.getSql();

        if ("com.yeejoin.equipmanage.mapper.FormInstanceMapper.queryForMapList".equals(id)) {
            //执行结果
            HashMap<String, String> par = new LinkedHashMap<>();
            if (parameter instanceof HashMap) {
                par = (HashMap<String, String>) ((HashMap<?, ?>) parameter).get("params");
            }


            Iterator<String> iterator = par.keySet().stream().iterator();

            while (iterator.hasNext()) {
                String next = iterator.next();
                sql = sql.replace("item", next);
            }

            //通过反射修改sql语句
            Field field = boundSql.getClass().getDeclaredField("sql");
            ReflectionUtils.makeAccessible(field);
            field.set(boundSql, sql);
            return executor.query(mappedStatement, parameter, rowBounds, resultHandler, cacheKey, boundSql);
        } else if ("com.yeejoin.equipmanage.mapper.FireFightingSystemMapper.getSystemInfoPage".equals(id) ||
                "com.yeejoin.equipmanage.mapper.EmergencyMapper.alarmList".equals(id) || "com.yeejoin.equipmanage.mapper.CarMapper.getCarInfoPage".equals(id)) {
            //执行结果
            String sortField = "";
            if (parameter instanceof HashMap) {
                sortField = ((HashMap<?, ?>) parameter).get("sortField").toString();
            }
            sql = sql.replace("@SORT_FIELD", sortField);
            //通过反射修改sql语句
            Field field = boundSql.getClass().getDeclaredField("sql");
            ReflectionUtils.makeAccessible(field);
            field.set(boundSql, sql);
            return executor.query(mappedStatement, parameter, rowBounds, resultHandler, cacheKey, boundSql);
        } else {
            return invocation.proceed();
        }
    }

    public Object plugin(Object target) {
        return Plugin.wrap(target, this);
    }

    public void setProperties(Properties properties) {
        System.out.println("====setProperties======");
    }

}