package com.yeejoin.equipmanage.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.service.IService;
import com.yeejoin.equipmanage.common.entity.EquipmentIndex;
import com.yeejoin.equipmanage.common.entity.vo.EquipmentIndexVO;

import java.util.List;

public interface IEquipmentIndexService extends IService<EquipmentIndex> {

    void updateE(Long id);

    /**
     * 获取单个性能指标信息
     * @param id
     * @return
     */
    EquipmentIndexVO getOnePrefQuota(Long id);

    /**
     * 查重
     * @param id
     * @param dataId
     * @param fId
     * @return
     */
    String checkName(Long id,Long dataId,Long fId);

    /**
     * 保存
     * @param
     * @return
     */
    boolean savePerfQuota(EquipmentIndex equipmentIndex );

    /**
     * 分页查询
     * @param page
     * @param id
     * @param groupName
     * @return
     */
    IPage<EquipmentIndexVO> getPerfQutoaPage(IPage<EquipmentIndex> page, Long id, String groupName);

    /**
     * 分页查询
     * @param id
     * @return
     */
    List<EquipmentIndexVO> getPerfQutoaList(Long id);

    /**
     * 查询计量单位是否在性能参数中使用
     * @return
     */
    int checkUnit(List<String > ids);

    /**
     * 查询性能参数名称
     */
    List<EquipmentIndexVO> getEquipmentIndexByIot();

    List<String> getGruopName(Long equipmentId);


    /**
     * 分页查询
     * @param id
     * @return
     */
    List<EquipmentIndex> getPerfQutoaIotList(Long id);

}
