package com.yeejoin.equipmanage.utils;

import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.BeanWrapperImpl;

import liquibase.util.StringUtil;

import java.util.HashSet;
import java.util.Set;

/**
 * @Author: xl
 * @Description:
 * @Date: 2021/9/13 19:35
 */
public class BeanUtil {

    public static String[] getNullPropertyNames (Object source) {
        final BeanWrapper src = new BeanWrapperImpl(source);
        java.beans.PropertyDescriptor[] pds = src.getPropertyDescriptors();

        Set<String> emptyNames = new HashSet<String>();
        for(java.beans.PropertyDescriptor pd : pds) {
            Object srcValue = src.getPropertyValue(pd.getName());
            if (srcValue == null) emptyNames.add(pd.getName());
        }
        String[] result = new String[emptyNames.size()];
        return emptyNames.toArray(result);
    }

    public static void copyPropertiesIgnoreNull(Object src, Object target){
        BeanUtils.copyProperties(src, target, getNullPropertyNames(src));
    }

    public static boolean judgePropertyContainsChar(String sourceStr, String specialStr) {
        boolean bool = Boolean.FALSE;
        if(StringUtil.isEmpty(sourceStr) || StringUtil.isEmpty(specialStr)){
        	 return bool;
        }
        specialStr = specialStr.trim();
        sourceStr = sourceStr.trim();
        String[] strings = specialStr.split(",");
        for (String code : strings) {
            if (sourceStr.contains(code)) {
                bool = Boolean.TRUE;
                break;
            }
        }
        return bool;
    }
}
