package com.yeejoin.amos.adpter.controller;


import com.yeejoin.amos.adpter.service.AdpterService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;
import org.typroject.tyboot.core.foundation.enumeration.UserType;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Map;


/**
 * 同步接口
 *
 * @author system_generator
 * @date 2021-06-29
 */
@RestController
@Slf4j
@Api(tags = "同步接口Api")
@RequestMapping(value = "/adpter")
public class AdpterController {


    @Autowired
    AdpterService adpterService;

    /**
     * 同步接口Api
     *
     * @return
     */
    @GetMapping(value = "/tran")
    @ApiOperation(httpMethod = "GET", value = "同步接口Api", notes = "同步接口Api")
    public Map<String,String> tran() {
        Map<String, String> handle = adpterService.handle();
        return handle;
    }

    /**
     * 数据库脚本执行Api
     *
     * @return
     */
    @PostMapping(value = "/execute/file")
    @ApiOperation(httpMethod = "POST", value = "脚本执行接口Api", notes = "脚本执行接口Api")
    public void executeSqlFile(HttpServletRequest request, HttpServletResponse response, @RequestParam(value = "dbHost") String dbHost, @RequestParam(value = "port") String port,
                                 @RequestParam(value = "dbName") String dbName, @RequestParam(value = "userName") String userName,
                                 @RequestParam(value = "dbPwd") String dbPwd, @RequestPart(value = "file") MultipartFile file) throws UnsupportedEncodingException {
        adpterService.executeSqlFile(request, response, dbHost, port, dbName, userName, dbPwd, file);
    }

    @ApiOperation(value = "主设备关联信息同步")
    @RequestMapping(value = "/syncMainDeviceRelation", method = RequestMethod.POST)
    public void syncMainDeviceRelation() throws IOException {
        adpterService.syncMainDeviceRelation();
    }

    @ApiOperation(value = "视频信息及主设备绑定视频关系同步")
    @RequestMapping(value = "/syncMainVideoRelation", method = RequestMethod.POST)
    public void syncMainVideoRelation(@RequestParam(value = "orgCode") String orgCode,
                                      @RequestParam(value = "agencyCode") String agencyCode)  {
        adpterService.syncMainVideoRelation(orgCode, agencyCode);
    }

    @ApiOperation(value = "建筑信息")
    @RequestMapping(value = "/buildingExcel", method = RequestMethod.POST)
    public void systemExcel(HttpServletResponse response,@RequestParam(value = "gatewayId") String gatewayId) throws IOException {
        adpterService.buildingExcel(response, gatewayId);
    }

    @ApiOperation(value = "人员信息")
    @RequestMapping(value = "/personExcel", method = RequestMethod.POST)
    public void personExcel(HttpServletResponse response) throws IOException {
        adpterService.personExcel(response);
    }

    /**
     * 同步amos_project系统人员和单位表
     *
     * @return
     */
    @GetMapping(value = "/cpSysUserOrg")
    @ApiOperation(httpMethod = "GET", value = "同步amos_project系统人员和单位表", notes = "同步amos_project系统人员和单位表")
    public Map<String,String> cpSysUserOrg() {
        return adpterService.cpSysUserOrg();
    }
}