SELECT a.*
from (
         SELECT '网关名称'                    AS gatewayDevice,
                case
                    when temp.DATA_TYPE = 'int' then '遥测'
                    else '遥信'
                    end                   as pointType,
                temp.DATA_TYPE            as pointDataType,
                '告警配置'                    AS alarmConfig,
                wws.`code`                AS areaCode,
                wws.`name`                AS areaName,
                wws.full_name             AS areaFullName,
                temp.ADDRESS              AS address,
                temp.`NAME`               AS pointName,
                temp.FIELD_NAME,
                temp.equipment_index_name AS iotProperName,
                temp.equipment_index_key  as equipmentIndexKey,
                wes.`code`                AS deviceCode,
                wed.equipment_name        AS deviceType,
                wes.`name`                AS deviceName,
                wed.standard              AS specs,
                wed.production_date       AS productionDate,
                wed.delivery_date         AS useDate,
                wmf.`name`                AS manufacturer,
                we.maintenance_cycle      AS mainDate,
                we.expiry_date            AS scraplife,
                wes.warranty_period       AS period,
                ffs.`name`                AS `system`,
                SUBSTR(temp.PRODUCT_KEY,  3)          AS equipTypeCode
         FROM (
                  SELECT gdp.DATA_TYPE,
                         gdp.PRODUCT_KEY,
                         gdp.DEVICE_CODE,
                         gdp.`NAME`,
                         gdp.FIELD_NAME,
                         gdp.ADDRESS,
                         esi.iot_code,
                         esi.equipment_index_key,
                         esi.equipment_specific_id,
                         esi.equipment_index_name
                  FROM iot_gateway_device_property gdp
                           LEFT JOIN (SELECT iot_code, equipment_index_key, equipment_index_name, equipment_specific_id
                                      FROM wl_equipment_specific_index
                                      GROUP BY iot_code, equipment_specific_id, equipment_index_key,
                                               equipment_index_name) esi
                                     ON CONCAT(gdp.PRODUCT_KEY, gdp.DEVICE_CODE) = esi.iot_code
                                         AND gdp.FIELD_NAME = esi.equipment_index_key
                  WHERE gdp.GATEWAY_ID = #{gatewayId}
           and gdp.ADDRESS IS NOT NULL
              ) temp
                  LEFT JOIN wl_equipment_specific wes ON wes.id = temp.equipment_specific_id
                  LEFT JOIN wl_equipment_detail wed ON wed.id = wes.equipment_detail_id
                  LEFT JOIN wl_equipment we ON we.id = wed.equipment_id
                  LEFT JOIN wl_warehouse_structure wws ON wws.id = wes.warehouse_structure_id
                  LEFT JOIN f_fire_fighting_system ffs ON ffs.id = wes.system_id
                  LEFT JOIN wl_manufacturer_info wmf ON wmf.id = wed.manufacturer_id
         ORDER BY CAST(temp.ADDRESS AS DECIMAL) ASC
     ) a