package com.yeejoin.amos.boot.module.tcm.api.service;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.tcm.api.dto.RiskProcessesDto;
import com.yeejoin.amos.boot.module.tcm.api.dto.RiskReportDto;
import com.yeejoin.amos.boot.module.tcm.api.entity.RiskReport;
import com.yeejoin.amos.feign.systemctl.model.DictionarieValueModel;

import java.util.List;
import java.util.Map;

/**
 * 风险报送表接口类
 *
 * @author system_generator
 * @date 2025-08-08
 */
public interface IRiskReportService {

    Page<Map<String, String>> allAgencyWithPage(int current, int size, boolean isAdmin, String companyName);

    JSONObject superviseOrgForEnter(String enterSeq);

    List<DictionarieValueModel> riskTypeByPermission();

    Page<RiskReport> queryForRiskReportPage(RiskReportDto reportDto, int current, int size);

    RiskReport saveOrUpdateReport(RiskReportDto dto);

    RiskReportDto selectRiskDetail(Long sequenceNbr);

    Boolean forWardeBySeq(Long riskReportSeq, RiskProcessesDto riskProcessesDto);

    List<String> permissionButton(Long sequenceNbr);

    Boolean riskDisposal(Long sequenceNbr, RiskProcessesDto riskProcessesDto);
}
