package com.yeejoin.amos.boot.module.tcm.flc.biz.service.impl;

import com.yeejoin.amos.boot.module.tcm.flc.api.entity.CylinderFillingCheck;
import com.yeejoin.amos.boot.module.tcm.flc.api.mapper.CylinderFillingCheckMapper;
import com.yeejoin.amos.boot.module.tcm.flc.api.service.ICylinderFillingCheckService;
import com.yeejoin.amos.boot.module.tcm.flc.api.dto.CylinderFillingCheckDto;
import org.typroject.tyboot.core.rdbms.service.BaseService;
import org.springframework.stereotype.Service;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;

import java.util.Date;
import java.util.List;

/**
 * 液化气体气瓶充装信息-充装后复查服务实现类
 *
 * @author system_generator
 * @date 2022-03-04
 */
@Service
public class CylinderFillingCheckServiceImpl extends BaseService<CylinderFillingCheckDto, CylinderFillingCheck,CylinderFillingCheckMapper> implements ICylinderFillingCheckService {
    /**
     * 分页查询
     */
    public Page<CylinderFillingCheckDto> queryForCylinderFillingCheckPage(Page<CylinderFillingCheckDto> page)   {
        return this.queryForPage(page, null, false);
    }

    /**
     * 列表查询 示例
     */
    public List<CylinderFillingCheckDto> queryForCylinderFillingCheckList()   {
        return this.queryForList("" , false);
    }

    public Double queryIntegirtyByAppId(String appId) {
        return this.baseMapper.queryIntegirtyByAppId(appId);
    }

    public Integer getFillingCountByMonth(String appId, Date time) {
        return this.baseMapper.getFillingCountByMonth(appId,time);
    }

    public Integer getFillingPassedCountByMonth(String appId, Date time) {
        return this.baseMapper.getFillingPassedCountByMonth(appId,time);
    }
}