package com.yeejoin.amos.boot.module.tcm.api.converter;

import com.alibaba.excel.converters.Converter;
import com.alibaba.excel.enums.CellDataTypeEnum;
import com.alibaba.excel.metadata.CellData;
import com.alibaba.excel.metadata.GlobalConfiguration;
import com.alibaba.excel.metadata.property.ExcelContentProperty;

import java.util.HashMap;
import java.util.Map;

public class PostTypeConverter implements Converter<String> {

    private static final Map<String, String> CODE_MAP = new HashMap<>();
    static {
        CODE_MAP.put("安全员", "6549");
        CODE_MAP.put("主要负责人", "6548");
        CODE_MAP.put("安全总监", "6547");
        CODE_MAP.put("普通员工", "6546");
        CODE_MAP.put("作业人员", "6552");
        CODE_MAP.put("质量安全员", "6551");
        CODE_MAP.put("质量安全总监", "6550");
        CODE_MAP.put("业务办理人员", "6616");
        CODE_MAP.put("安改维负责人", "6553");
        CODE_MAP.put("安全管理员", "6617");
        CODE_MAP.put("维保人员", "6618");
        CODE_MAP.put("检验人员", "66151");
        CODE_MAP.put("检测人员", "66152");
        CODE_MAP.put("质量保证体系人员", "6619");
    }
    @Override
    public Class supportJavaTypeKey() {
        return String.class;
    }

    @Override
    public CellDataTypeEnum supportExcelTypeKey() {
        return CellDataTypeEnum.STRING;
    }

    @Override
    public String convertToJavaData(CellData cellData, ExcelContentProperty contentProperty, GlobalConfiguration globalConfiguration) throws Exception {
        String cellDataStr = cellData.getStringValue();
        return CODE_MAP.getOrDefault(cellDataStr, "6546");
    }

    @Override
    public CellData convertToExcelData(String value, ExcelContentProperty contentProperty, GlobalConfiguration globalConfiguration) throws Exception {
        return null;
    }
}
