package com.yeejoin.amos.boot.module.tdc.biz.controller;

import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.module.tdc.api.dto.CheckResultDto;
import com.yeejoin.amos.boot.module.tdc.api.entity.CheckModel;
import com.yeejoin.amos.boot.module.tdc.api.entity.CheckResult;
import com.yeejoin.amos.boot.module.tdc.api.service.CheckResultService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.util.List;


/**
 * 校验结果
 * @author xxz
 */
@RestController
@Api(tags = "校验结果Api")
@RequestMapping(value = "/check-result")
public class CheckResultController extends BaseController {

    @Autowired
    CheckResultService checkResultService;

    /**
     * cs
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY,needAuth = false)
    @GetMapping(value = "/selectResult/{code}")
    @ApiOperation(httpMethod = "GET", value = "result", notes = "result")
    public ResponseModel<List<CheckResultDto>> selectResult(@PathVariable(value = "code") String code) {
        return ResponseHelper.buildResponse(checkResultService.selectResult(code));
    }
}
