package com.yeejoin.amos.boot.module.tcm.api.enums;

import lombok.Getter;

/**
 * 业务类型枚举
 *
 * @author Administrator
 */
@Getter
public enum SafetyProblemSourceTypeEnum {

    /**
     * 问题主体类型
     */
    UNIT("2", "企业"),

    EQUIP("3", "设备"),

    PERSONNEL("1", "个人");

    private final String code;

    private final String name;

    SafetyProblemSourceTypeEnum(String code, String name) {
        this.code = code;
        this.name = name;
    }

    public static String getNameByType(String code) {
        String name = null;
        for (SafetyProblemSourceTypeEnum enumOne : SafetyProblemSourceTypeEnum.values()) {
            if (enumOne.getCode().equals(code)) {
                name = enumOne.getName();
                break;
            }
        }
        return name;
    }

}
