package com.yeejoin.amos.boot.module.elevator.biz.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.yeejoin.amos.boot.biz.common.bo.ReginParams;
import com.yeejoin.amos.boot.module.elevator.api.dto.UserCheckStatusDto;
import com.yeejoin.amos.boot.module.elevator.api.entity.UserCheckStatus;
import com.yeejoin.amos.boot.module.elevator.api.mapper.UserCheckStatusMapper;
import com.yeejoin.amos.boot.module.elevator.api.service.IUserCheckStatusService;
import com.yeejoin.amos.feign.privilege.model.RoleModel;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;
import org.typroject.tyboot.core.rdbms.service.BaseService;

import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * 企业端赋码说明相关实现类
 *
 * @author system_generator
 * @date 2021-10-20
 */
@Service
@Slf4j
public class UserCheckStatusServiceImpl extends BaseService<UserCheckStatusDto, UserCheckStatus, UserCheckStatusMapper> implements IUserCheckStatusService {

    @Autowired
    UserCheckStatusMapper userCheckStatusMapper;

    //使用单位sequence_nbr
    private final Long USEUNITID = 1460532889249755137L;

    @Override
    public UserCheckStatus getUserCheckStatus(ReginParams reginParams) {
        UserCheckStatus userCheckStatus = new UserCheckStatus();
        userCheckStatus.setStatus("1");
        Map<Long, List<RoleModel>> orgRoles = reginParams.getUserModel().getOrgRoles();
        if(!ObjectUtils.isEmpty(orgRoles)){
            Set<Long> longs = orgRoles.keySet();
            for (Long aLong : longs) {
                for (RoleModel roleModel : orgRoles.get(aLong)) {
                    if(USEUNITID.equals(roleModel.getSequenceNbr())){
                        String useName = reginParams.getUserModel().getUserName();
                        userCheckStatus = userCheckStatusMapper.selectOne(new QueryWrapper<UserCheckStatus>().eq("use_name", useName));
                        if (ObjectUtils.isEmpty(userCheckStatus)) {
                            UserCheckStatus checkStatus = new UserCheckStatus();
                            checkStatus.setUseName(useName);
                            checkStatus.setStatus("0");
                            int result = userCheckStatusMapper.insert(checkStatus);
                            if (result == 1) {
                                return checkStatus;
                            } else {
                                return null;
                            }
                        }
                    }
                }
            }
        }
        return userCheckStatus;
    }

    @Override
    public UserCheckStatus updateUserCheckStatus(String useName, String status) {
        if(!ObjectUtils.isEmpty(useName)){
            UserCheckStatus checkStatus = new UserCheckStatus();
            checkStatus.setUseName(useName);
            checkStatus.setStatus(status);
            int result = userCheckStatusMapper.update(checkStatus,new QueryWrapper<UserCheckStatus>().eq("use_name", useName));
            if (result == 1) {
                return checkStatus;
            }
        }
        return null;
    }
}