package com.yeejoin.amos.boot.module.common.api.dto;

import lombok.Data;

import javax.validation.constraints.NotBlank;

/**
 * 大屏筛选过滤对象
 *
 * @author Administrator
 */
@Data
public class DPFilterParamForDetailDto {
    /**
     * 区域
     */
    @NotBlank(message = "区域编码不能为空！")
    private String cityCode;

    /**
     * 业务类型
     */
    private String businessType;

    /**
     * 时间筛选
     */
    private DPFilterParamForDateDto timeSearchOne;

    /**
     * 当前页
     */

    private int current = 1;

    /**
     * 每页大小
     */
    private int size = 20;

    /**
     * 左侧树选中值
     */
    private String treeValue;

    /**
     * 设备类别
     */
    private String equCategoryCode;

    /**
     * 监管单位名称（接收单位/管辖机构）
     */
    private String superviseUnitName;

    /**
     * 企业单位名称（发起单位/使用单位）
     */
    private String companyName;

}
