package com.yeejoin.amos.api.openapi.controller;

import com.yeejoin.amos.api.openapi.feign.TzsTcmServiceFeignClient;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

/**
 * @author Administrator
 */
@RestController
@RequestMapping(value = "/data-dict")
public class DataDictionaryController {

    @Autowired
    TzsTcmServiceFeignClient tzsTcmServiceFeignClient;

    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @GetMapping(value = "/{dictCode}/list")
    @ApiOperation(httpMethod = "POST", value = "查询指定的字典列表", notes = "查询指定的字典列表")
    public ResponseModel<Object> dictList(@PathVariable String dictCode) {
        return tzsTcmServiceFeignClient.getDataDictionary(dictCode);
    }


}
