package com.yeejoin.amos.boot.module.jg.biz.edit.constant;

import java.util.*;

public class ChangeFieldWatchConstants {

    /**
     * 台套-使用登记证影响字段
     */
    public static final Set<String> USE_CERT_MONITORED_FIELDS =
            Collections.unmodifiableSet(new HashSet<>(Arrays.asList(
                    "equDefine", "equCode", "useInnerCode", "factoryNum",
                    "province", "city", "county", "street", "factoryUseSiteStreet", "address", "useOrgCode", "carNumber", "useRegistrationCode",
                    "receiveCompanyCode"
            )));

    /**
     * 标志-台套-设备编辑影响字段
     */
    public static final Set<String> USE_FLAG_MONITORED_FIELDS =
            Collections.unmodifiableSet(new HashSet<>(Arrays.asList(
                    "equDefine", "equCode", "useInnerCode", "inspectOrgName", "nextInspectDate",
                    "emergencyTel", "maintenanceUnitName", "useOrgCode", "useRegistrationCode", "receiveCompanyCode"
            )));

    /**
     * 标志-车用气瓶-设备编辑影响字段
     */
    public static final Set<String> USE_FLAG_VEHICLE_MONITORED_FIELDS =
            Collections.unmodifiableSet(new HashSet<>(Arrays.asList(
                    "productName", "carNumber", "factoryNum", "gasNum", "volume", "fillingMedium", "inspectOrgName",
                    "nextInspectDate", "useOrgCode", "useRegistrationCode"
            )));

    /**
     * 管道汇总表-设备编辑影响字段
     */
    public static final Set<String> PIPELINE_SUMMARY_TABLE_MONITORED_FIELDS =
            Collections.unmodifiableSet(new HashSet<>(Arrays.asList(
                    "pipeName", "pipelineNumber", "deviceLevel", "designUnitName", "uscUnitName", "workPressure", "workTemperature", "workMedium",
                    "uscDate", "useDate", "nominalDiameter", "wallThickness", "pipeLength", "pressure", "temperature",
                    "medium", "inspectConclusion", "inspectOrgName", "nextInspectDate", "remarks")));

    /**
     * 使用登记-气瓶汇总表-设备编辑影响字段
     */
    public static final Set<String> USE_CYLINDER_SUMMARY_TABLE_MONITORED_FIELDS =
            Collections.unmodifiableSet(new HashSet<>(Arrays.asList(
                    "equDefine", "factoryNum", "chargingMedium", "produceUnitName", "produceDate", "nominalWorkingPressure", "singleBottleVolume", "inspectDate",
                    "nextInspectDate", "useInnerCode")));

    /**
     * 安装告知-设备编辑影响字段
     */
    public static final Set<String> NOTICE_MONITORED_FIELDS =
            Collections.unmodifiableSet(new HashSet<>(Arrays.asList(
                    "equCode", "productName", "contactPhone", "installUnitName",
                    "equipType", "factoryNum", "produceUnitName", "produceLicenseNum", "province",
                    "city", "county", "street", "factoryUseSiteStreet", "address", "useOrgCode", "useRegistrationCode"
            )));

    /**
     * 所有分类映射
     */
    private static final Map<String, Set<String>> FIELD_MAP;

    static {
        Map<String, Set<String>> map = new LinkedHashMap<>();
        map.put("USE_FLAG", USE_FLAG_MONITORED_FIELDS);
        map.put("USE_FLAG_VEHICLE", USE_FLAG_VEHICLE_MONITORED_FIELDS);
        map.put("PIPELINE_SUMMARY", PIPELINE_SUMMARY_TABLE_MONITORED_FIELDS);
        map.put("USE_CYLINDER_SUMMARY", USE_CYLINDER_SUMMARY_TABLE_MONITORED_FIELDS);
        map.put("NOTICE", NOTICE_MONITORED_FIELDS);
        map.put("USE_CERT", USE_CERT_MONITORED_FIELDS);
        FIELD_MAP = Collections.unmodifiableMap(map);
    }

    /**
     * 判断是否是任何一类监控字段
     */
    public static boolean isWatched(String columnKey) {
        for (Set<String> fieldSet : FIELD_MAP.values()) {
            if (fieldSet.contains(columnKey)) {
                return true;
            }
        }
        return false;
    }

    /**
     * 获取字段所属的所有分类
     */
    public static Set<String> getMatchedCategories(String columnKey) {
        Set<String> matched = new HashSet<>();
        for (Map.Entry<String, Set<String>> entry : FIELD_MAP.entrySet()) {
            if (entry.getValue().contains(columnKey)) {
                matched.add(entry.getKey());
            }
        }
        return matched;
    }
}
